/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.contentassist;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class TypeCompletionProposal
extends AbstractJavaCompletionProposal
implements ICompletionProposalExtension4 {
    protected String fAdditionalInfo;
    private boolean fProposalInfoComputed;
    private IProject fProject;
    private String fTypeName;

    public TypeCompletionProposal(String replacementString, Image image, String displayString, int startOffset, int length, IProject project, String typeName) {
        this(replacementString, image, displayString, startOffset, length);
        this.fTypeName = typeName;
        this.fProject = project;
    }

    public TypeCompletionProposal(String replacementString, Image image, String displayString, int startOffset, int length) {
        Assert.isNotNull((Object)replacementString);
        this.setReplacementString(replacementString);
        this.setReplacementOffset(startOffset);
        this.setReplacementLength(length);
        this.setDisplayString(displayString);
        this.setImage(image);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        if (this.getReplacementLength() == -1) {
            this.setReplacementLength(document.getLength());
        }
        try {
            document.replace(this.getReplacementOffset(), this.getReplacementLength(), this.getReplacementString());
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        if (this.getReplacementString().equals("\"\"")) {
            return new Point(this.getReplacementOffset() + 1, 0);
        }
        return new Point(this.getReplacementOffset() + this.getReplacementString().length(), 0);
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.fAdditionalInfo != null) {
            return this.fAdditionalInfo;
        }
        return super.getAdditionalProposalInfo(monitor);
    }

    public void setAdditionalProposalInfo(String info) {
        this.fAdditionalInfo = info;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    protected final ProposalInfo getProposalInfo() {
        if (!this.fProposalInfoComputed) {
            this.setProposalInfo(this.computeProposalInfo());
            this.fProposalInfoComputed = true;
        }
        return super.getProposalInfo();
    }

    protected ProposalInfo computeProposalInfo() {
        if (this.fProject != null && this.fTypeName != null) {
            return new PDETypeProposalInfo(JavaCore.create((IProject)this.fProject), this.fTypeName);
        }
        return null;
    }

    private static final class PDETypeProposalInfo
    extends ProposalInfo {
        private final IJavaProject fJavaProject;
        private final String fTypeName;

        public PDETypeProposalInfo(IJavaProject project, String typeName) {
            this.fJavaProject = project;
            this.fTypeName = typeName;
        }

        public IJavaElement getJavaElement() throws JavaModelException {
            return this.fJavaProject.findType(this.fTypeName);
        }
    }
}

