/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.contentassist;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaRootElement;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.text.XMLUtil;

public class XMLInsertionComputer {
    public static void computeInsertion(ISchemaElement sElement, IPluginParent pElement) {
        HashSet<String> visited = new HashSet<String>();
        if (sElement == null || pElement == null) {
            return;
        }
        visited.add(sElement.getName());
        try {
            XMLInsertionComputer.computeInsertionParent(sElement, pElement, visited);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected static void computeInsertionParent(ISchemaElement sElement, IPluginParent pElement, HashSet<String> visited) throws CoreException {
        if (XMLInsertionComputer.isSingleZeroElementEdgeCase(sElement, pElement)) {
            XMLInsertionComputer.computeInsertionZeroElementEdgeCase(sElement, pElement, visited);
        } else {
            XMLInsertionComputer.computeInsertionType(sElement, pElement, visited);
        }
    }

    protected static void computeInsertionZeroElementEdgeCase(ISchemaElement sElement, IPluginParent pElement, HashSet<String> visited) throws CoreException {
        XMLInsertionComputer.computeInsertionAllAttributes(pElement, sElement);
        ISchemaCompositor compositor = ((ISchemaComplexType)sElement.getType()).getCompositor();
        ISchemaElement childSchemaElement = (ISchemaElement)compositor.getChildren()[0];
        IPluginElement childElement = XMLInsertionComputer.createElement(pElement, childSchemaElement);
        visited.add(childSchemaElement.getName());
        XMLInsertionComputer.computeInsertionType(childSchemaElement, (IPluginParent)childElement, visited);
        pElement.add((IPluginObject)childElement);
    }

    protected static boolean isSingleZeroElementEdgeCase(ISchemaElement sElement, IPluginParent pElement) {
        if (sElement.getType() instanceof ISchemaComplexType && pElement instanceof IPluginExtension) {
            ISchemaCompositor compositor = ((ISchemaComplexType)sElement.getType()).getCompositor();
            if (compositor == null || !XMLInsertionComputer.isSequenceCompositor(compositor) || compositor.getChildCount() != 1 || compositor.getMinOccurs() != 1) {
                return false;
            }
            ISchemaObject schemaObject = compositor.getChildren()[0];
            if (!(schemaObject instanceof ISchemaElement)) {
                return false;
            }
            ISchemaElement schemaElement = (ISchemaElement)schemaObject;
            if (schemaElement.getMinOccurs() == 0) {
                return true;
            }
        }
        return false;
    }

    protected static void computeInsertionType(ISchemaElement sElement, IPluginParent pElement, HashSet<String> visited) throws CoreException {
        if (sElement == null || pElement == null) {
            return;
        }
        if (sElement.getType() instanceof ISchemaSimpleType) {
            try {
                if (pElement instanceof IPluginElement) {
                    ((IPluginElement)pElement).setText(NLS.bind((String)PDEUIMessages.XMLCompletionProposal_InfoElement, (Object)pElement.getName()));
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
            return;
        }
        if (!(sElement.getType() instanceof ISchemaComplexType)) {
            return;
        }
        XMLInsertionComputer.computeInsertionAllAttributes(pElement, sElement);
        ISchemaCompositor compositor = ((ISchemaComplexType)sElement.getType()).getCompositor();
        XMLInsertionComputer.computeInsertionSequence(compositor, pElement, visited);
    }

    /*
     * WARNING - void declaration
     */
    protected static void computeInsertionObject(IPluginParent pElement, HashSet<String> visited, ISchemaObject schemaObject) throws CoreException {
        ISchemaObject iSchemaObject = schemaObject;
        if (iSchemaObject instanceof ISchemaElement) {
            void schemaElement;
            ISchemaElement iSchemaElement = (ISchemaElement)iSchemaObject;
            ISchemaElement cfr_ignored_0 = (ISchemaElement)iSchemaObject;
            XMLInsertionComputer.computeInsertionElement(pElement, visited, (ISchemaElement)schemaElement);
        } else {
            ISchemaObject iSchemaObject2 = schemaObject;
            if (iSchemaObject2 instanceof ISchemaCompositor) {
                void sCompositor;
                ISchemaCompositor iSchemaCompositor = (ISchemaCompositor)iSchemaObject2;
                ISchemaCompositor cfr_ignored_1 = (ISchemaCompositor)iSchemaObject2;
                XMLInsertionComputer.computeInsertionSequence((ISchemaCompositor)sCompositor, pElement, visited);
            }
        }
    }

    protected static boolean isSequenceCompositor(ISchemaCompositor compositor) {
        if (compositor == null) {
            return false;
        }
        if (compositor.getKind() == 1) {
            return false;
        }
        if (compositor.getKind() == 0) {
            return false;
        }
        if (compositor.getKind() == 3) {
            return false;
        }
        return compositor.getKind() == 2;
    }

    protected static void computeInsertionElement(IPluginParent pElement, HashSet<String> visited, ISchemaElement schemaElement) throws CoreException {
        int j = 0;
        while (j < schemaElement.getMinOccurs()) {
            IPluginElement childElement = XMLInsertionComputer.createElement(pElement, schemaElement);
            HashSet newSet = (HashSet)visited.clone();
            if (newSet.add(schemaElement.getName())) {
                XMLInsertionComputer.computeInsertionType(schemaElement, (IPluginParent)childElement, newSet);
            } else {
                childElement.setText(PDEUIMessages.XMLCompletionProposal_ErrorCycle);
            }
            pElement.add((IPluginObject)childElement);
            ++j;
        }
    }

    protected static IPluginElement createElement(IPluginParent pElement, ISchemaElement schemaElement) throws CoreException {
        IPluginElement childElement = pElement.getModel().getFactory().createElement((IPluginObject)pElement);
        childElement.setName(schemaElement.getName());
        return childElement;
    }

    protected static void computeInsertionAllAttributes(IPluginParent pElement, ISchemaElement sElement) {
        ISchemaComplexType type = (ISchemaComplexType)sElement.getType();
        IResource resource = pElement.getModel().getUnderlyingResource();
        IProject project = null;
        if (resource != null) {
            project = resource.getProject();
        }
        ISchemaAttribute[] attributes = type.getAttributes();
        int counter = XMLUtil.getCounterValue(sElement);
        int i = 0;
        while (i < type.getAttributeCount()) {
            ISchemaAttribute attribute = attributes[i];
            try {
                Object value;
                if (attribute.getUse() == 1) {
                    value = XMLInsertionComputer.generateAttributeValue(project, counter, attribute);
                    XMLInsertionComputer.setAttribute(pElement, attribute.getName(), (String)value, counter);
                } else if (attribute.getUse() == 2 && (value = attribute.getValue()) instanceof String && attribute.getKind() != 1 && (!attribute.getType().getName().equals("boolean") || ((String)value).equalsIgnoreCase("true") || ((String)value).equalsIgnoreCase("false"))) {
                    XMLInsertionComputer.setAttribute(pElement, attribute.getName(), (String)value, counter);
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
            ++i;
        }
    }

    protected static String generateAttributeValue(IProject project, int counter, ISchemaAttribute attribute) {
        String value = "";
        ISchemaRestriction restriction = attribute.getType().getRestriction();
        if (attribute.getKind() == 1 && project != null) {
            value = XMLUtil.createDefaultClassName(project, attribute, counter);
        } else if (restriction != null) {
            value = restriction.getChildren()[0].toString();
        } else if (attribute instanceof SchemaAttribute && ((SchemaAttribute)attribute).isTranslatable()) {
            value = attribute.getName();
        } else if (project != null) {
            value = XMLUtil.createDefaultName(project, attribute, counter);
        }
        return value;
    }

    public static String generateAttributeValue(ISchemaAttribute attribute, IBaseModel baseModel, String defaultValue) {
        IResource resource;
        if (baseModel instanceof IModel && (resource = ((IModel)baseModel).getUnderlyingResource()) != null) {
            int counter = 1;
            if (attribute.getParent() instanceof ISchemaElement) {
                ISchemaElement sElement = (ISchemaElement)attribute.getParent();
                if (sElement instanceof ISchemaRootElement) {
                    return defaultValue;
                }
                counter = XMLUtil.getCounterValue(sElement);
            }
            return XMLInsertionComputer.generateAttributeValue(resource.getProject(), counter, attribute);
        }
        return defaultValue;
    }

    protected static void computeInsertionSequence(ISchemaCompositor compositor, IPluginParent pElement, HashSet<String> visited) throws CoreException {
        if (compositor == null) {
            return;
        }
        int k = 0;
        while (k < compositor.getMinOccurs()) {
            if (XMLInsertionComputer.isSequenceCompositor(compositor)) {
                ISchemaObject[] schemaObject = compositor.getChildren();
                int i = 0;
                while (i < compositor.getChildCount()) {
                    XMLInsertionComputer.computeInsertionObject(pElement, visited, schemaObject[i]);
                    ++i;
                }
            }
            ++k;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static void setAttribute(IPluginParent parent, String attName, String attValue, int counter) throws CoreException {
        if (parent instanceof IPluginElement) {
            ((IPluginElement)parent).setAttribute(attName, attValue);
        } else {
            IPluginParent iPluginParent = parent;
            if (iPluginParent instanceof IPluginExtension) {
                String currValue;
                void pe;
                IPluginExtension iPluginExtension = (IPluginExtension)iPluginParent;
                IPluginExtension cfr_ignored_0 = (IPluginExtension)iPluginParent;
                if (attName.equals("id")) {
                    String currValue2 = pe.getId();
                    if (currValue2 == null || currValue2.length() == 0) {
                        pe.setId(attName + counter);
                    }
                } else if (attName.equals("name")) {
                    String currValue3 = pe.getName();
                    if (currValue3 == null || currValue3.length() == 0) {
                        pe.setName(attName);
                    }
                } else if (attName.equals("point") && ((currValue = pe.getPoint()) == null || currValue.length() == 0)) {
                    pe.setPoint(attValue);
                }
            }
        }
    }

    public static boolean hasOptionalAttributes(ISchemaElement ele) {
        ISchemaAttribute[] attrs;
        ISchemaAttribute[] iSchemaAttributeArray = attrs = ele.getAttributes();
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            ISchemaAttribute attr = iSchemaAttributeArray[n2];
            if (attr.getUse() == 0 || attr.getUse() == 2) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasOptionalChildren(ISchemaObject obj, boolean onChild, HashSet<ISchemaObject> set) {
        ISchemaObject[] children;
        if (obj == null || set.contains(obj)) {
            return false;
        }
        set.add(obj);
        if (obj instanceof ISchemaElement) {
            if (onChild && ((ISchemaElement)obj).getMinOccurs() == 0 && ((ISchemaElement)obj).getMaxOccurs() > 0) {
                return true;
            }
            ISchemaType type = ((ISchemaElement)obj).getType();
            if (type instanceof ISchemaComplexType) {
                return XMLInsertionComputer.hasOptionalChildren((ISchemaObject)((ISchemaComplexType)type).getCompositor(), true, set);
            }
        } else if (obj instanceof ISchemaCompositor && (children = ((ISchemaCompositor)obj).getChildren()) != null) {
            ISchemaObject[] iSchemaObjectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ISchemaObject child = iSchemaObjectArray[n2];
                if (XMLInsertionComputer.hasOptionalChildren(child, true, set)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

