/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.plugin.GeneralInfoSection;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.validation.ControlValidationUtility;
import org.eclipse.pde.internal.ui.editor.validation.TextValidator;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.plugin.NewPluginProjectWizard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.osgi.framework.BundleException;

public class FragmentGeneralInfoSection
extends GeneralInfoSection {
    private FormEntry fPluginIdEntry;
    private FormEntry fPluginMinVersionEntry;
    private FormEntry fPluginMaxVersionEntry;
    private ComboPart fPluginMinVersionBound;
    private ComboPart fPluginMaxVersionBound;
    private ComboPart fMatchCombo;
    private TextValidator fPluginIdValidator;
    private TextValidator fPluginMinVersionValidator;
    private TextValidator fPluginMaxVersionValidator;

    public FragmentGeneralInfoSection(PDEFormPage page, Composite parent) {
        super(page, parent);
    }

    @Override
    protected String getSectionDescription() {
        return PDEUIMessages.ManifestEditor_PluginSpecSection_fdesc;
    }

    @Override
    protected void createSpecificControls(Composite parent, FormToolkit toolkit, IActionBars actionBars) {
        this.createPluginIdEntry(parent, toolkit, actionBars);
        this.createPluginVersionEntry(parent, toolkit, actionBars);
        if (!this.isBundle()) {
            this.createMatchCombo(parent, toolkit, actionBars);
        }
        this.createSingleton(parent, toolkit, actionBars, PDEUIMessages.FragmentGeneralInfoSection_singleton);
    }

    private void createPluginIdEntry(Composite parent, FormToolkit toolkit, IActionBars actionBars) {
        this.fPluginIdEntry = new FormEntry(parent, toolkit, PDEUIMessages.GeneralInfoSection_pluginId, PDEUIMessages.GeneralInfoSection_browse, this.isEditable());
        this.fPluginIdEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                try {
                    ((IFragment)FragmentGeneralInfoSection.this.getPluginBase()).setPluginId(FragmentGeneralInfoSection.this.fPluginIdEntry.getValue());
                }
                catch (CoreException e1) {
                    PDEPlugin.logException(e1);
                }
            }

            @Override
            public void linkActivated(HyperlinkEvent e) {
                String plugin = FragmentGeneralInfoSection.this.fPluginIdEntry.getValue();
                if (!(PluginRegistry.findModel((String)plugin) instanceof IPluginModel)) {
                    this.createFragmentPlugin();
                }
                ManifestEditor.openPluginEditor(FragmentGeneralInfoSection.this.fPluginIdEntry.getValue());
            }

            @Override
            public void browseButtonSelected(FormEntry entry) {
                FragmentGeneralInfoSection.this.handleOpenDialog();
            }

            private void createFragmentPlugin() {
                NewPluginProjectWizard wizard = new NewPluginProjectWizard("Equinox");
                wizard.init(PDEPlugin.getActiveWorkbenchWindow().getWorkbench(), (IStructuredSelection)new StructuredSelection());
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                if (dialog.open() == 0) {
                    String plugin = wizard.getPluginId();
                    try {
                        ((IFragment)FragmentGeneralInfoSection.this.getPluginBase()).setPluginId(plugin);
                        FragmentGeneralInfoSection.this.fPluginIdEntry.setValue(plugin, false);
                    }
                    catch (CoreException ce) {
                        PDEPlugin.logException(ce);
                    }
                }
            }
        });
        this.fPluginIdEntry.setEditable(this.isEditable());
        this.fPluginIdValidator = new TextValidator(this.getManagedForm(), this.fPluginIdEntry.getText(), this.getProject(), true){

            @Override
            protected boolean validateControl() {
                return FragmentGeneralInfoSection.this.validatePluginId();
            }
        };
    }

    private boolean validatePluginId() {
        return ControlValidationUtility.validateFragmentHostPluginField(this.fPluginIdEntry.getText().getText(), this.fPluginIdValidator, this.getProject());
    }

    protected void handleOpenDialog() {
        PluginSelectionDialog dialog = new PluginSelectionDialog(this.getSection().getShell(), false, false);
        dialog.create();
        if (dialog.open() == 0) {
            IPluginModel model = (IPluginModel)dialog.getFirstResult();
            IPlugin plugin = model.getPlugin();
            try {
                ((IFragment)this.getPluginBase()).setPluginId(plugin.getId());
                this.fPluginMinVersionEntry.setValue(plugin.getVersion());
                ((IFragment)this.getPluginBase()).setPluginVersion(this.getVersion());
            }
            catch (CoreException coreException) {}
        }
    }

    private void createPluginVersionEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        if (this.isBundle()) {
            this.createBundlePluginVersionEntry(client, toolkit, actionBars);
        } else {
            this.createNonBundlePluginVersionEntry(client, toolkit, actionBars);
        }
    }

    private void createBundlePluginVersionEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        FormEntryAdapter textListener = new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                try {
                    ((IFragment)FragmentGeneralInfoSection.this.getPluginBase()).setPluginVersion(FragmentGeneralInfoSection.this.getVersion());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            @Override
            public void textDirty(FormEntry entry) {
                FragmentGeneralInfoSection.this.setFieldsEnabled();
                super.textDirty(entry);
            }
        };
        String[] items = new String[]{PDEUIMessages.DependencyPropertiesDialog_comboInclusive, PDEUIMessages.DependencyPropertiesDialog_comboExclusive};
        this.fPluginMinVersionEntry = new FormEntry(client, toolkit, PDEUIMessages.GeneralInfoSection_hostMinVersionRange, 0, 1);
        this.fPluginMinVersionEntry.setFormEntryListener(textListener);
        this.fPluginMinVersionEntry.setEditable(this.isEditable());
        this.fPluginMinVersionValidator = new TextValidator(this.getManagedForm(), this.fPluginMinVersionEntry.getText(), this.getProject(), true){

            @Override
            protected boolean validateControl() {
                return FragmentGeneralInfoSection.this.validatePluginMinVersion();
            }
        };
        SelectionListener comboListener = SelectionListener.widgetSelectedAdapter(event -> {
            try {
                ((IFragment)this.getPluginBase()).setPluginVersion(this.getVersion());
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        });
        this.fPluginMinVersionBound = new ComboPart();
        this.fPluginMinVersionBound.createControl(client, toolkit, 8);
        this.fPluginMinVersionBound.getControl().setLayoutData((Object)new TableWrapData(128));
        this.fPluginMinVersionBound.setItems(items);
        this.fPluginMinVersionBound.getControl().setEnabled(this.isEditable());
        this.fPluginMinVersionBound.addSelectionListener(comboListener);
        this.fPluginMaxVersionEntry = new FormEntry(client, toolkit, PDEUIMessages.GeneralInfoSection_hostMaxVersionRange, 0, 1);
        this.fPluginMaxVersionEntry.setFormEntryListener(textListener);
        this.fPluginMaxVersionEntry.setEditable(this.isEditable());
        this.fPluginMaxVersionValidator = new TextValidator(this.getManagedForm(), this.fPluginMaxVersionEntry.getText(), this.getProject(), true){

            @Override
            protected boolean validateControl() {
                return FragmentGeneralInfoSection.this.validatePluginMaxVersion();
            }
        };
        this.fPluginMaxVersionBound = new ComboPart();
        this.fPluginMaxVersionBound.createControl(client, toolkit, 8);
        this.fPluginMaxVersionBound.getControl().setLayoutData((Object)new TableWrapData(128));
        this.fPluginMaxVersionBound.setItems(items);
        this.fPluginMaxVersionBound.getControl().setEnabled(this.isEditable());
        this.fPluginMaxVersionBound.addSelectionListener(comboListener);
    }

    private boolean validatePluginMaxVersion() {
        if (this.fPluginMaxVersionEntry.getText().getText().length() == 0) {
            return true;
        }
        return ControlValidationUtility.validateVersionField(this.fPluginMaxVersionEntry.getText().getText(), this.fPluginMaxVersionValidator);
    }

    private boolean validatePluginMinVersion() {
        if (this.fPluginMinVersionEntry.getText().getText().length() == 0) {
            return true;
        }
        return ControlValidationUtility.validateVersionField(this.fPluginMinVersionEntry.getText().getText(), this.fPluginMinVersionValidator);
    }

    private void createNonBundlePluginVersionEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fPluginMinVersionEntry = new FormEntry(client, toolkit, PDEUIMessages.GeneralInfoSection_pluginVersion, null, false);
        this.fPluginMinVersionEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                try {
                    ((IFragment)FragmentGeneralInfoSection.this.getPluginBase()).setPluginVersion(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fPluginMinVersionEntry.setEditable(this.isEditable());
    }

    private void createMatchCombo(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        Label matchLabel = toolkit.createLabel(client, PDEUIMessages.ManifestEditor_PluginSpecSection_versionMatch);
        matchLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        TableWrapData td = new TableWrapData();
        td.valign = 32;
        matchLabel.setLayoutData((Object)td);
        this.fMatchCombo = new ComboPart();
        this.fMatchCombo.createControl(client, toolkit, 8);
        td = new TableWrapData(128);
        td.colspan = 2;
        td.valign = 32;
        this.fMatchCombo.getControl().setLayoutData((Object)td);
        String[] items = new String[]{"", PDEUIMessages.ManifestEditor_MatchSection_equivalent, PDEUIMessages.ManifestEditor_MatchSection_compatible, PDEUIMessages.ManifestEditor_MatchSection_perfect, PDEUIMessages.ManifestEditor_MatchSection_greater};
        this.fMatchCombo.setItems(items);
        this.fMatchCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            int match = this.fMatchCombo.getSelectionIndex();
            try {
                ((IFragment)this.getPluginBase()).setRule(match);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }));
        this.fMatchCombo.getControl().setEnabled(this.isEditable());
    }

    @Override
    public void commit(boolean onSave) {
        this.fPluginIdEntry.commit();
        this.fPluginMinVersionEntry.commit();
        this.fPluginMaxVersionEntry.commit();
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        this.fPluginIdEntry.cancelEdit();
        this.fPluginMinVersionEntry.cancelEdit();
        this.fPluginMaxVersionEntry.cancelEdit();
        super.cancelEdit();
    }

    @Override
    public void refresh() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        IFragment fragment = (IFragment)model.getPluginBase();
        this.fPluginIdEntry.setValue(fragment.getPluginId(), true);
        if (this.isBundle()) {
            this.refreshVersion();
        } else {
            this.fPluginMinVersionEntry.setValue(fragment.getPluginVersion(), true);
        }
        if (this.fMatchCombo != null) {
            this.fMatchCombo.select(fragment.getRule());
        }
        super.refresh();
    }

    protected String getAttribute(String header, String attribute) {
        IBundle bundle = this.getBundle();
        if (bundle == null) {
            return null;
        }
        String value = bundle.getHeader(header);
        if (value == null) {
            return null;
        }
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)header, (String)value);
            if (elements.length > 0) {
                return elements[0].getAttribute(attribute);
            }
        }
        catch (BundleException bundleException) {}
        return null;
    }

    private void setFieldsEnabled() {
        boolean singleVersion = this.fPluginMaxVersionEntry.getText().getText().trim().length() == 0;
        boolean enabled = this.fPluginMinVersionEntry.getText().getText().trim().length() != 0;
        this.fPluginMaxVersionEntry.getText().setEnabled(enabled);
        this.fPluginMaxVersionBound.getControl().setEnabled(!singleVersion && enabled && this.isEditable());
        this.fPluginMinVersionBound.getControl().setEnabled(!singleVersion && this.isEditable());
    }

    private String getVersion() {
        if (this.isBundle() && !this.fPluginMinVersionEntry.getValue().equals(this.fPluginMaxVersionEntry.getValue()) && this.fPluginMaxVersionEntry.getText().getEnabled()) {
            if (this.fPluginMaxVersionEntry.getValue().length() == 0) {
                return this.fPluginMinVersionEntry.getValue();
            }
            Object version = this.fPluginMinVersionBound.getSelectionIndex() == 0 ? "[" : "(";
            version = (String)version + this.fPluginMinVersionEntry.getValue() + "," + this.fPluginMaxVersionEntry.getValue();
            version = this.fPluginMaxVersionBound.getSelectionIndex() == 0 ? (String)version + "]" : (String)version + ")";
            return version;
        }
        return this.fPluginMinVersionEntry.getValue();
    }

    private void refreshVersion() {
        String version = this.getAttribute("Fragment-Host", "bundle-version");
        if (version == null) {
            this.setVersionFields("", true, "", false);
            this.setFieldsEnabled();
            return;
        }
        version = version.trim();
        int comInd = version.indexOf(44);
        int lastPos = version.length() - 1;
        char first = version.charAt(0);
        char last = version.charAt(lastPos);
        if (comInd == -1) {
            this.setVersionFields(version, true, "", false);
        } else if (!(first != '[' && first != '(' || last != ']' && last != ')')) {
            version = version.substring(1, lastPos);
            this.setVersionFields(version.substring(0, comInd - 1), first == '[', version.substring(comInd), last == ']');
        }
        this.setFieldsEnabled();
    }

    private void setVersionFields(String minVersion, boolean minInclusive, String maxVersion, boolean maxInclusive) {
        this.fPluginMinVersionEntry.setValue(minVersion, true);
        this.fPluginMinVersionBound.select(minInclusive ? 0 : 1);
        this.fPluginMaxVersionEntry.setValue(maxVersion, true);
        this.fPluginMaxVersionBound.select(maxInclusive ? 0 : 1);
    }

    @Override
    protected void addListeners() {
        IBundleModel model;
        if (this.isBundle() && (model = this.getBundle().getModel()) != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
        super.addListeners();
    }

    @Override
    protected void removeListeners() {
        IBundleModel model;
        if (this.isBundle() && (model = this.getBundle().getModel()) != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.removeListeners();
    }
}

