/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.features.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.views.features.model.IProductModelListener;
import org.eclipse.pde.internal.ui.views.features.model.ProductModelManager;

public class FeatureIndex
implements IFeatureModelListener,
IProductModelListener {
    private final FeatureModelManager fFeatureModelManager;
    private final ProductModelManager fProductModelManager;
    private volatile Map<String, Collection<IFeatureModel>> fIncludingFeatures;
    private volatile Map<String, Collection<IProductModel>> fIncludingProducts;

    public FeatureIndex(FeatureModelManager featureModelManager, ProductModelManager productModelManager) {
        this.fFeatureModelManager = featureModelManager;
        this.fFeatureModelManager.addFeatureModelListener((IFeatureModelListener)this);
        this.fProductModelManager = productModelManager;
        this.fProductModelManager.addProductModelListener(this);
    }

    public boolean isInitialized() {
        return this.fIncludingFeatures != null && this.fIncludingProducts != null;
    }

    public void ensureInitialized() {
        if (!this.isInitialized()) {
            this.reIndex();
        }
    }

    public Collection<IFeatureModel> getIncludingFeatures(String childId) {
        this.ensureInitialized();
        return this.fIncludingFeatures.getOrDefault(childId, Collections.emptySet());
    }

    public Collection<IProductModel> getIncludingProducts(String featureId) {
        this.ensureInitialized();
        return this.fIncludingProducts.getOrDefault(featureId, Collections.emptySet());
    }

    public void dispose() {
        this.fFeatureModelManager.removeFeatureModelListener((IFeatureModelListener)this);
        this.fProductModelManager.removeProductModelListener(this);
    }

    private void reIndex() {
        int n;
        int n2;
        IFeatureChild[] iFeatureChildArray;
        HashMap<String, Collection<IFeatureModel>> includingFeatures = new HashMap<String, Collection<IFeatureModel>>();
        HashMap<String, Collection<IProductModel>> includingProducts = new HashMap<String, Collection<IProductModel>>();
        IFeatureModel[] iFeatureModelArray = this.fFeatureModelManager.getModels();
        int n3 = iFeatureModelArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IFeatureModel parentModel = iFeatureModelArray[n4];
            iFeatureChildArray = parentModel.getFeature().getIncludedFeatures();
            n2 = iFeatureChildArray.length;
            n = 0;
            while (n < n2) {
                IFeatureChild child = iFeatureChildArray[n];
                IFeatureModel childModel = this.fFeatureModelManager.findFeatureModel(child.getId());
                if (childModel != null) {
                    this.index(includingFeatures, childModel, parentModel);
                }
                ++n;
            }
            ++n4;
        }
        iFeatureModelArray = this.fProductModelManager.getModels();
        n3 = iFeatureModelArray.length;
        n4 = 0;
        while (n4 < n3) {
            IFeatureModel productModel = iFeatureModelArray[n4];
            iFeatureChildArray = productModel.getProduct().getFeatures();
            n2 = iFeatureChildArray.length;
            n = 0;
            while (n < n2) {
                IFeatureChild productFeature = iFeatureChildArray[n];
                IFeatureModel featureModel = this.fFeatureModelManager.findFeatureModel(productFeature.getId());
                if (featureModel != null) {
                    this.index(includingProducts, featureModel, (IProductModel)productModel);
                }
                ++n;
            }
            ++n4;
        }
        this.fIncludingFeatures = includingFeatures;
        this.fIncludingProducts = includingProducts;
    }

    private void index(Map<String, Collection<IFeatureModel>> includingFeatures, IFeatureModel childModel, IFeatureModel parentModel) {
        String childId = childModel.getFeature().getId();
        Collection parents = includingFeatures.computeIfAbsent(childId, key -> new HashSet());
        parents.add(parentModel);
    }

    private void index(Map<String, Collection<IProductModel>> includingProducts, IFeatureModel childModel, IProductModel productModel) {
        String featureId = childModel.getFeature().getId();
        Collection products = includingProducts.computeIfAbsent(featureId, key -> new HashSet());
        products.add(productModel);
    }

    public void modelsChanged(IFeatureModelDelta delta) {
        this.reIndex();
    }

    @Override
    public void modelsChanged() {
        this.reIndex();
    }
}

