/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.plugins;

import java.io.File;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.FileAdapter;
import org.eclipse.pde.internal.core.IFileAdapterFactory;
import org.eclipse.pde.internal.core.ModelFileAdapter;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.ui.views.plugins.PluginsView;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;

public class PluginsContentProvider
implements ITreeContentProvider {
    private final PluginsView fView;
    private final StandardJavaElementContentProvider fJavaProvider;
    private DeferredTreeContentManager fManager = null;

    public PluginsContentProvider(PluginsView view) {
        this.fView = view;
        this.fJavaProvider = new StandardJavaElementContentProvider();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            if (this.fManager != null) {
                this.fManager.cancel(oldInput);
            }
            return;
        }
        this.fManager = new DeferredTreeContentManager((AbstractTreeViewer)viewer);
        this.fManager.addUpdateCompleteListener(this.getCompletionJobListener());
        this.fView.updateTitle(newInput);
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IDeferredWorkbenchAdapter) {
            if (PDECore.getDefault().getModelManager().isInitialized()) {
                return PDECore.getDefault().getModelManager().getAllModels();
            }
            Object[] children = this.fManager.getChildren(parentElement);
            return children;
        }
        Object object = parentElement;
        if (object instanceof IPluginModelBase) {
            void model;
            IPluginModelBase children = (IPluginModelBase)object;
            IPluginModelBase cfr_ignored_0 = (IPluginModelBase)object;
            File file = new File(model.getInstallLocation());
            if (!file.isFile()) {
                ModelFileAdapter adapter = new ModelFileAdapter((IPluginModelBase)model, file, (IFileAdapterFactory)PDECore.getDefault().getSearchablePluginsManager());
                return adapter.getChildren();
            }
        }
        if (parentElement instanceof FileAdapter) {
            return ((FileAdapter)parentElement).getChildren();
        }
        if (parentElement instanceof IPackageFragmentRoot || parentElement instanceof IPackageFragment || parentElement instanceof ICompilationUnit || parentElement instanceof IStorage) {
            return this.fJavaProvider.getChildren(parentElement);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof PluginModelManager) {
            return null;
        }
        if (element instanceof IPluginModelBase) {
            return PDECore.getDefault().getModelManager();
        }
        if (element instanceof ModelFileAdapter) {
            return ((ModelFileAdapter)element).getModel();
        }
        if (element instanceof FileAdapter) {
            return ((FileAdapter)element).getParent();
        }
        if (element instanceof IJarEntryResource) {
            return ((IJarEntryResource)element).getParent();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasChildren(Object element) {
        if (element instanceof IDeferredWorkbenchAdapter) {
            return this.fManager.mayHaveChildren(element);
        }
        Object object = element;
        if (object instanceof IPluginModelBase) {
            void model;
            IPluginModelBase iPluginModelBase = (IPluginModelBase)object;
            IPluginModelBase cfr_ignored_0 = (IPluginModelBase)object;
            return model.getUnderlyingResource() == null && !new File(model.getInstallLocation()).isFile();
        }
        Object object2 = element;
        if (object2 instanceof FileAdapter) {
            void fileAdapter;
            FileAdapter fileAdapter2 = (FileAdapter)object2;
            FileAdapter cfr_ignored_1 = (FileAdapter)object2;
            return fileAdapter.hasChildren();
        }
        if (element instanceof IPackageFragmentRoot || element instanceof IPackageFragment || element instanceof ICompilationUnit || element instanceof IStorage) {
            return this.fJavaProvider.hasChildren(element);
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    protected IJobChangeListener getCompletionJobListener() {
        return new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    PluginsContentProvider.this.fView.updateContentDescription();
                }
            }
        };
    }
}

