/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.internal.core.text.IDocumentKey;
import org.eclipse.pde.internal.core.util.PropertiesUtil;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEProjectionSourcePage;

public abstract class KeyValueSourcePage
extends PDEProjectionSourcePage {
    public KeyValueSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    public ViewerComparator createDefaultOutlineComparator() {
        return new ViewerComparator(){

            /*
             * WARNING - void declaration
             */
            public int compare(Viewer viewer, Object e1, Object e2) {
                Object object = e1;
                if (object instanceof IDocumentKey) {
                    IDocumentKey iDocumentKey = (IDocumentKey)object;
                    IDocumentKey cfr_ignored_0 = (IDocumentKey)object;
                    if (e2 instanceof IDocumentKey) {
                        void key1;
                        IDocumentKey key2 = (IDocumentKey)e2;
                        return Integer.compare(key1.getOffset(), key2.getOffset());
                    }
                }
                return 0;
            }
        };
    }

    public void setHighlightRange(IDocumentKey key) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        int offset = key.getOffset();
        int length = key.getLength();
        if (offset == -1 || length == -1) {
            return;
        }
        this.setHighlightRange(offset, length, true);
        int nameLength = PropertiesUtil.createWritableName((String)key.getName()).length();
        sourceViewer.setSelectedRange(offset, Math.min(nameLength, length));
    }

    @Override
    public ViewerComparator createOutlineComparator() {
        return new ViewerComparator();
    }

    @Override
    public boolean isQuickOutlineEnabled() {
        return true;
    }
}

