/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.IDocumentKey;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;
import org.eclipse.pde.internal.core.text.bundle.PackageFriend;
import org.eclipse.pde.internal.core.util.PropertiesUtil;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.ManifestDocumentSetupParticipant;
import org.eclipse.pde.internal.ui.editor.context.UTF8InputContext;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class BundleInputContext
extends UTF8InputContext {
    public static final String CONTEXT_ID = "bundle-context";
    private final HashMap<IDocumentKey, TextEdit> fOperationTable = new HashMap();

    public BundleInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    @Override
    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        boolean isReconciling = input instanceof IFileEditorInput;
        IDocument document = this.getDocumentProvider().getDocument((Object)input);
        BundleModel model = new BundleModel(document, isReconciling);
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            model.setUnderlyingResource((IResource)file);
            model.setCharset(Charset.forName(file.getCharset()));
        } else if (input instanceof IURIEditorInput) {
            IFileStore store = EFS.getStore((URI)((IURIEditorInput)input).getURI());
            model.setInstallLocation(store.getParent().getParent().toString());
            model.setCharset(this.getDefaultCharset());
        } else if (input instanceof JarEntryEditorInput) {
            File file = ((JarEntryEditorInput)input).getAdapter(File.class);
            model.setInstallLocation(file.toString());
            model.setCharset(this.getDefaultCharset());
        } else {
            model.setCharset(this.getDefaultCharset());
        }
        model.load();
        return model;
    }

    public BundleModel getModel() {
        return (BundleModel)super.getModel();
    }

    @Override
    public String getId() {
        return CONTEXT_ID;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addTextEditOperation(ArrayList<TextEdit> ops, IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof PDEManifestElement) {
                    object = ((PDEManifestElement)object).getHeader();
                } else if (object instanceof PackageFriend) {
                    object = ((PackageFriend)object).getHeader();
                }
                Object object2 = object;
                if (object2 instanceof ManifestHeader) {
                    String value;
                    void header;
                    ManifestHeader cfr_ignored_0 = (ManifestHeader)object2;
                    ManifestHeader cfr_ignored_1 = (ManifestHeader)object2;
                    TextEdit op = this.fOperationTable.get(header);
                    if (op != null) {
                        this.fOperationTable.remove(header);
                        ops.remove(op);
                    }
                    if ((value = header.getValue()) == null || value.trim().length() == 0) {
                        this.deleteKey((IDocumentKey)header, ops);
                    } else {
                        this.modifyKey((ManifestHeader)header, ops);
                    }
                }
                ++n2;
            }
        }
    }

    protected TextEdit[] getMoveOperations() {
        return new TextEdit[0];
    }

    private void insertKey(ManifestHeader key, ArrayList<TextEdit> ops) {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
        String write = key.write();
        int offset = this.getInsertOffset(key, doc);
        InsertEdit op = new InsertEdit(offset, write);
        this.fOperationTable.put((IDocumentKey)key, (TextEdit)op);
        ops.add((TextEdit)op);
    }

    private int getInsertOffset(ManifestHeader key, IDocument doc) {
        IBundle bundle = key.getBundle();
        List manifestHeaders = bundle.getManifestHeaders().values().stream().filter(header -> !"Manifest-Version".equalsIgnoreCase(header.getKey()) && !"Bundle-ManifestVersion".equalsIgnoreCase(header.getKey())).sorted(Comparator.comparing(IManifestHeader::getKey, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        int indexOf = manifestHeaders.indexOf(key);
        if (indexOf > -1) {
            if (indexOf == 0) {
                IManifestHeader header2 = bundle.getManifestHeader("Bundle-ManifestVersion");
                if (header2 != null && header2.getOffset() > -1) {
                    return header2.getOffset() + header2.getLength();
                }
            } else {
                IManifestHeader header3 = (IManifestHeader)manifestHeaders.get(indexOf - 1);
                return header3.getOffset() + header3.getLength();
            }
        }
        return PropertiesUtil.getInsertOffset((IDocument)doc);
    }

    private void deleteKey(IDocumentKey key, ArrayList<TextEdit> ops) {
        if (key.getOffset() > 0) {
            DeleteEdit op = new DeleteEdit(key.getOffset(), key.getLength());
            this.fOperationTable.put(key, (TextEdit)op);
            ops.add((TextEdit)op);
        }
    }

    private void modifyKey(ManifestHeader key, ArrayList<TextEdit> ops) {
        if (key.getOffset() == -1) {
            this.insertKey(key, ops);
        } else {
            ReplaceEdit op = new ReplaceEdit(key.getOffset(), key.getLength(), key.write());
            this.fOperationTable.put((IDocumentKey)key, (TextEdit)op);
            ops.add((TextEdit)op);
        }
    }

    @Override
    public void doRevert() {
        this.fEditOperations.clear();
        this.fOperationTable.clear();
        BundleModel model = this.getModel();
        model.reconciled(model.getDocument());
    }

    @Override
    protected String getPartitionName() {
        return "___bundle_partition";
    }

    @Override
    protected IDocumentSetupParticipant getDocumentSetupParticipant() {
        return new ManifestDocumentSetupParticipant();
    }
}

