/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.nLayout.area.style.BackgroundImageInfo;
import org.w3c.dom.css.CSSValue;

public class AttributeBuilder {
    public static String buildPos(DimensionType x, DimensionType y, DimensionType width, DimensionType height) {
        StringBuffer content = new StringBuffer();
        if (x != null || y != null) {
            content.append("position: relative;");
            AttributeBuilder.buildSize(content, "left", x);
            AttributeBuilder.buildSize(content, "top", y);
        }
        AttributeBuilder.buildSize(content, "width", width);
        AttributeBuilder.buildSize(content, "height", height);
        return content.toString();
    }

    public static void buildVisual(StringBuffer styleBuffer, IStyle style) {
        AttributeBuilder.buildProperty(styleBuffer, "line-height", style.getLineHeight());
    }

    public static void buildBackground(StringBuffer styleBuffer, IStyle style, HTMLReportEmitter emitter, DimensionType[] parentSize) {
        AttributeBuilder.buildProperty(styleBuffer, "background-color", style.getBackgroundColor());
        String image = style.getBackgroundImage();
        if (image == null || "none".equalsIgnoreCase(image)) {
            if (style.getBackgroundHeight() != null || style.getBackgroundWidth() != null) {
                AttributeBuilder.addPropName(styleBuffer, "background-size");
                if (style.getBackgroundWidth() != null && style.getBackgroundHeight() != null) {
                    AttributeBuilder.addPropValue(styleBuffer, "100%");
                    AttributeBuilder.addPropValue(styleBuffer, "auto");
                    AttributeBuilder.addPropValue(styleBuffer, "auto");
                } else {
                    if (style.getBackgroundWidth() != null) {
                        AttributeBuilder.addPropValue(styleBuffer, style.getBackgroundWidth());
                    } else {
                        AttributeBuilder.addPropValue(styleBuffer, "auto");
                    }
                    if (style.getBackgroundHeight() != null) {
                        AttributeBuilder.addPropValue(styleBuffer, style.getBackgroundHeight());
                    } else {
                        AttributeBuilder.addPropValue(styleBuffer, "auto");
                    }
                }
                styleBuffer.append(';');
            }
            return;
        }
        BackgroundImageInfo backgroundImage = emitter.handleStyleImage(image, true, style);
        if ((image = backgroundImage.getUri()) != null && image.length() > 0) {
            AttributeBuilder.buildURLProperty(styleBuffer, "background-image", image);
            AttributeBuilder.buildProperty(styleBuffer, "background-repeat", style.getBackgroundRepeat());
            AttributeBuilder.buildProperty(styleBuffer, "background-attachment", style.getBackgroundAttachment());
            DimensionType height = null;
            DimensionType width = null;
            if (parentSize != null && parentSize.length == 2) {
                height = parentSize[0];
                width = parentSize[1];
            }
            AttributeBuilder.addPropName(styleBuffer, "background-size");
            Object h = backgroundImage.getHeight() + "px";
            Object w = backgroundImage.getWidth() + "px";
            String propertyValue = style.getPropertyValue("background-height");
            String propertyValue2 = style.getPropertyValue("background-width");
            if (propertyValue != null && ("cover".equals(propertyValue) || "contain".equals(propertyValue))) {
                if ("contain".equals(propertyValue)) {
                    h = "auto";
                    if (width != null) {
                        w = width.toString();
                    }
                } else if ("cover".equals(propertyValue)) {
                    if (height != null) {
                        h = height.toString();
                    }
                    w = "auto";
                }
            }
            AttributeBuilder.addPropValue(styleBuffer, (String)w);
            AttributeBuilder.addPropValue(styleBuffer, (String)h);
            styleBuffer.append(';');
            String x = style.getBackgroundPositionX();
            String y = style.getBackgroundPositionY();
            if (x != null || y != null) {
                if (x == null) {
                    x = "0pt";
                }
                if (y == null) {
                    y = "0pt";
                }
                AttributeBuilder.addPropName(styleBuffer, "background-position");
                AttributeBuilder.addPropValue(styleBuffer, x);
                AttributeBuilder.addPropValue(styleBuffer, y);
                styleBuffer.append(';');
            }
        }
    }

    public static void buildBackgroundColor(StringBuffer styleBuffer, IStyle style, HTMLReportEmitter emitter) {
        AttributeBuilder.buildProperty(styleBuffer, "background-color", style.getBackgroundColor());
    }

    public static void buildBox(StringBuffer styleBuffer, IStyle style) {
        AttributeBuilder.buildMargins(styleBuffer, style);
        AttributeBuilder.buildPaddings(styleBuffer, style);
        AttributeBuilder.buildBorders(styleBuffer, style);
    }

    public static void buildMargins(StringBuffer styleBuffer, IStyle style) {
        String topMargin = style.getMarginTop();
        String rightMargin = style.getMarginRight();
        String bottomMargin = style.getMarginBottom();
        String leftMargin = style.getMarginLeft();
        if (topMargin != null && rightMargin != null && bottomMargin != null && leftMargin != null) {
            if (rightMargin.equals(leftMargin)) {
                if (topMargin.equals(bottomMargin)) {
                    if (topMargin.equals(rightMargin)) {
                        AttributeBuilder.buildProperty(styleBuffer, "margin", topMargin);
                    } else {
                        AttributeBuilder.addPropName(styleBuffer, "margin");
                        AttributeBuilder.addPropValue(styleBuffer, topMargin);
                        AttributeBuilder.addPropValue(styleBuffer, rightMargin);
                        styleBuffer.append(';');
                    }
                } else {
                    AttributeBuilder.addPropName(styleBuffer, "margin");
                    AttributeBuilder.addPropValue(styleBuffer, topMargin);
                    AttributeBuilder.addPropValue(styleBuffer, rightMargin);
                    AttributeBuilder.addPropValue(styleBuffer, bottomMargin);
                    styleBuffer.append(';');
                }
            } else {
                AttributeBuilder.addPropName(styleBuffer, "margin");
                AttributeBuilder.addPropValue(styleBuffer, topMargin);
                AttributeBuilder.addPropValue(styleBuffer, rightMargin);
                AttributeBuilder.addPropValue(styleBuffer, bottomMargin);
                AttributeBuilder.addPropValue(styleBuffer, leftMargin);
                styleBuffer.append(';');
            }
        } else {
            AttributeBuilder.buildProperty(styleBuffer, "margin-top", topMargin);
            AttributeBuilder.buildProperty(styleBuffer, "margin-right", rightMargin);
            AttributeBuilder.buildProperty(styleBuffer, "margin-bottom", bottomMargin);
            AttributeBuilder.buildProperty(styleBuffer, "margin-left", leftMargin);
        }
    }

    public static void buildPaddings(StringBuffer styleBuffer, IStyle style) {
        String topPadding = style.getPaddingTop();
        String rightPadding = style.getPaddingRight();
        String bottomPadding = style.getPaddingBottom();
        String leftPadding = style.getPaddingLeft();
        if (topPadding != null && rightPadding != null && bottomPadding != null && leftPadding != null) {
            if (rightPadding.equals(leftPadding)) {
                if (topPadding.equals(bottomPadding)) {
                    if (topPadding.equals(rightPadding)) {
                        AttributeBuilder.buildProperty(styleBuffer, "padding", topPadding);
                    } else {
                        AttributeBuilder.addPropName(styleBuffer, "padding");
                        AttributeBuilder.addPropValue(styleBuffer, topPadding);
                        AttributeBuilder.addPropValue(styleBuffer, rightPadding);
                        styleBuffer.append(';');
                    }
                } else {
                    AttributeBuilder.addPropName(styleBuffer, "padding");
                    AttributeBuilder.addPropValue(styleBuffer, topPadding);
                    AttributeBuilder.addPropValue(styleBuffer, rightPadding);
                    AttributeBuilder.addPropValue(styleBuffer, bottomPadding);
                    styleBuffer.append(';');
                }
            } else {
                AttributeBuilder.addPropName(styleBuffer, "padding");
                AttributeBuilder.addPropValue(styleBuffer, topPadding);
                AttributeBuilder.addPropValue(styleBuffer, rightPadding);
                AttributeBuilder.addPropValue(styleBuffer, bottomPadding);
                AttributeBuilder.addPropValue(styleBuffer, leftPadding);
                styleBuffer.append(';');
            }
        } else {
            AttributeBuilder.buildProperty(styleBuffer, "padding-top", topPadding);
            AttributeBuilder.buildProperty(styleBuffer, "padding-right", rightPadding);
            AttributeBuilder.buildProperty(styleBuffer, "padding-bottom", bottomPadding);
            AttributeBuilder.buildProperty(styleBuffer, "padding-left", leftPadding);
        }
    }

    public static void buildBorders(StringBuffer styleBuffer, IStyle style) {
        String topBorderWidth = style.getBorderTopWidth();
        String topBorderStyle = style.getBorderTopStyle();
        String topBorderColor = style.getBorderTopColor();
        String rightBorderWidth = style.getBorderRightWidth();
        String rightBorderStyle = style.getBorderRightStyle();
        String rightBorderColor = style.getBorderRightColor();
        String bottomBorderWidth = style.getBorderBottomWidth();
        String bottomBorderStyle = style.getBorderBottomStyle();
        String bottomBorderColor = style.getBorderBottomColor();
        String leftBorderWidth = style.getBorderLeftWidth();
        String leftBorderStyle = style.getBorderLeftStyle();
        String leftBorderColor = style.getBorderLeftColor();
        if ((topBorderWidth != null && topBorderWidth.equals(rightBorderWidth) && topBorderWidth.equals(bottomBorderWidth) && topBorderWidth.equals(leftBorderWidth) || topBorderWidth == null && rightBorderWidth == null && bottomBorderWidth == null && leftBorderWidth == null) && (topBorderStyle != null && topBorderStyle.equals(rightBorderStyle) && topBorderStyle.equals(bottomBorderStyle) && topBorderStyle.equals(leftBorderStyle) || topBorderStyle == null && rightBorderStyle == null && bottomBorderStyle == null && leftBorderStyle == null) && (topBorderColor != null && topBorderColor.equals(rightBorderColor) && topBorderColor.equals(bottomBorderColor) && topBorderColor.equals(leftBorderColor) || topBorderColor == null && rightBorderColor == null && bottomBorderColor == null && leftBorderColor == null)) {
            AttributeBuilder.buildBorder(styleBuffer, "border", topBorderWidth, topBorderStyle, topBorderColor);
            return;
        }
        AttributeBuilder.buildBorder(styleBuffer, "border-top", topBorderWidth, topBorderStyle, topBorderColor);
        AttributeBuilder.buildBorder(styleBuffer, "border-right", rightBorderWidth, rightBorderStyle, rightBorderColor);
        AttributeBuilder.buildBorder(styleBuffer, "border-bottom", bottomBorderWidth, bottomBorderStyle, bottomBorderColor);
        AttributeBuilder.buildBorder(styleBuffer, "border-left", leftBorderWidth, leftBorderStyle, leftBorderColor);
    }

    public static void buildText(StringBuffer styleBuffer, IStyle style) {
        AttributeBuilder.buildProperty(styleBuffer, "text-indent", style.getTextIndent());
        AttributeBuilder.buildProperty(styleBuffer, "letter-spacing", style.getLetterSpacing());
        AttributeBuilder.buildProperty(styleBuffer, "word-spacing", style.getWordSpacing());
        AttributeBuilder.buildProperty(styleBuffer, "text-transform", style.getTextTransform());
        AttributeBuilder.buildProperty(styleBuffer, "white-space", style.getWhiteSpace());
    }

    public static void buildFont(StringBuffer styleBuffer, IStyle style) {
        AttributeBuilder.buildProperty(styleBuffer, "font-family", style.getFontFamily());
        AttributeBuilder.buildProperty(styleBuffer, "font-style", style.getFontStyle());
        AttributeBuilder.buildProperty(styleBuffer, "font-variant", style.getFontVariant());
        AttributeBuilder.buildProperty(styleBuffer, "font-weight", style.getFontWeight());
        AttributeBuilder.buildProperty(styleBuffer, "font-size", style.getFontSize());
        AttributeBuilder.buildProperty(styleBuffer, "color", style.getColor());
    }

    public static void buildTextDecoration(StringBuffer styleBuffer, IStyle style) {
        CSSValue linethrough = style.getProperty(36);
        CSSValue underline = style.getProperty(62);
        CSSValue overline = style.getProperty(51);
        if (linethrough == CSSValueConstants.LINE_THROUGH_VALUE || underline == CSSValueConstants.UNDERLINE_VALUE || overline == CSSValueConstants.OVERLINE_VALUE) {
            styleBuffer.append(" text-decoration:");
            if (CSSValueConstants.LINE_THROUGH_VALUE == linethrough) {
                AttributeBuilder.addPropValue(styleBuffer, "line-through");
            }
            if (CSSValueConstants.UNDERLINE_VALUE == underline) {
                AttributeBuilder.addPropValue(styleBuffer, "underline");
            }
            if (CSSValueConstants.OVERLINE_VALUE == overline) {
                AttributeBuilder.addPropValue(styleBuffer, "overline");
            }
            styleBuffer.append(';');
        }
    }

    static void buildBorder(StringBuffer styleBuffer, String name, String width, String style, String color) {
        if (style == null || style.length() <= 0) {
            return;
        }
        AttributeBuilder.addPropName(styleBuffer, name);
        AttributeBuilder.addPropValue(styleBuffer, width);
        AttributeBuilder.addPropValue(styleBuffer, style);
        AttributeBuilder.addPropValue(styleBuffer, color == null ? "black" : color);
        styleBuffer.append(';');
    }

    public static void buildSize(StringBuffer styleBuffer, String name, DimensionType value) {
        if (value != null) {
            if ("min-height".equals(name)) {
                AttributeBuilder.addPropName(styleBuffer, "height");
                AttributeBuilder.addPropValue(styleBuffer, "auto !important");
                styleBuffer.append(';');
                AttributeBuilder.addPropName(styleBuffer, "height");
                AttributeBuilder.addPropValue(styleBuffer, value.toString());
                styleBuffer.append(';');
                AttributeBuilder.addPropName(styleBuffer, "min-height");
                AttributeBuilder.addPropValue(styleBuffer, value.toString());
                styleBuffer.append(';');
            } else {
                AttributeBuilder.addPropName(styleBuffer, name);
                AttributeBuilder.addPropValue(styleBuffer, value.toString());
                styleBuffer.append(';');
            }
        }
    }

    public static void buildSize(StringBuffer styleBuffer, IStyle style) {
        AttributeBuilder.buildProperty(styleBuffer, "height", style.getHeight());
        AttributeBuilder.buildProperty(styleBuffer, "width", style.getWidth());
    }

    private static void buildProperty(StringBuffer styleBuffer, String name, String value) {
        if (value != null) {
            AttributeBuilder.addPropName(styleBuffer, name);
            AttributeBuilder.addPropValue(styleBuffer, value);
            styleBuffer.append(';');
        }
    }

    private static void buildURLProperty(StringBuffer styleBuffer, String name, String url) {
        if (url != null) {
            AttributeBuilder.addPropName(styleBuffer, name);
            AttributeBuilder.addURLValue(styleBuffer, url);
            styleBuffer.append(';');
        }
    }

    private static void addPropName(StringBuffer styleBuffer, String name) {
        styleBuffer.append(' ');
        styleBuffer.append(name);
        styleBuffer.append(':');
    }

    private static void addPropValue(StringBuffer styleBuffer, String value) {
        if (value != null) {
            styleBuffer.append(' ');
            styleBuffer.append(value);
        }
    }

    private static void addURLValue(StringBuffer styleBuffer, String url) {
        if (url == null) {
            return;
        }
        if (url.length() > 0) {
            styleBuffer.append(" url('");
            styleBuffer.append(url);
            styleBuffer.append("')");
        }
    }

    public static void buildBidiDirection(StringBuffer styleBuffer, IStyle style) {
        String direction;
        if (style != null && (direction = style.getDirection()) != null) {
            AttributeBuilder.buildProperty(styleBuffer, "direction", direction);
        }
    }
}

