/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.ui.swt.AbstractChartIntSpinner;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class IntegerSpinControl
extends AbstractChartIntSpinner
implements SelectionListener,
Listener {
    private transient int iMinValue = 0;
    private transient int iMaxValue = 100;
    protected transient int iCurrentValue = 0;
    private transient int iIncrement = 1;
    protected transient Button btnIncrement = null;
    protected transient Button btnDecrement = null;
    protected transient TextEditorComposite txtValue = null;
    protected transient Vector<Listener> vListeners = null;
    public static final int VALUE_CHANGED_EVENT = 1;
    protected transient boolean bEnabled = true;

    public IntegerSpinControl(Composite parent, int style, int iCurrentValue) {
        super(parent, style);
        this.iCurrentValue = iCurrentValue;
        this.init();
        this.placeComponents();
        this.initAccessible();
    }

    public void addScreenreaderAccessbility(String description) {
        this.txtValue.addScreenreaderAccessbility(description);
    }

    private void init() {
        Display.getCurrent().getHighContrast();
        this.vListeners = new Vector();
    }

    protected void placeComponents() {
        this.creaetSpinner((Composite)this);
    }

    protected void creaetSpinner(Composite parent) {
        this.setLayout(new InternalLayout());
        this.txtValue = new TextEditorComposite((Composite)this, 2048);
        this.txtValue.setText(String.valueOf(this.iCurrentValue));
        this.txtValue.addListener(this);
        this.btnIncrement = new Button((Composite)this, 131076);
        this.btnIncrement.addSelectionListener((SelectionListener)this);
        this.btnDecrement = new Button((Composite)this, 16388);
        this.btnDecrement.addSelectionListener((SelectionListener)this);
    }

    public void setMinimum(int iMin) {
        this.iMinValue = iMin;
    }

    public int getMinimum() {
        return this.iMinValue;
    }

    public void setMaximum(int iMax) {
        this.iMaxValue = iMax;
    }

    public int getMaximum() {
        return this.iMaxValue;
    }

    public void setIncrement(int iIncrement) {
        this.iIncrement = iIncrement;
    }

    public void setValue(int iCurrent) {
        this.iCurrentValue = iCurrent;
        this.txtValue.setText(String.valueOf(this.iCurrentValue));
    }

    public int getValue() {
        return this.iCurrentValue;
    }

    public void setEnabled(boolean bState) {
        super.setEnabled(bState);
        this.setEnabledImpl(bState);
        this.bEnabled = bState;
    }

    protected void setEnabledImpl(boolean bState) {
        this.btnIncrement.setEnabled(bState);
        this.btnDecrement.setEnabled(bState);
        this.txtValue.setEnabled(bState);
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public boolean isSpinnerEnabled() {
        return this.isEnabled();
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    public void widgetSelected(SelectionEvent e) {
        int iTextValue = this.iCurrentValue;
        try {
            iTextValue = Integer.parseInt(this.txtValue.getText());
        }
        catch (NumberFormatException e1) {
            return;
        }
        Object oSource = e.getSource();
        if (oSource.equals(this.btnIncrement)) {
            if (this.iCurrentValue < this.iMaxValue && iTextValue >= this.iMinValue && iTextValue < this.iMaxValue) {
                this.iCurrentValue = iTextValue + this.iIncrement;
                this.txtValue.setText(String.valueOf(this.iCurrentValue));
            } else if (iTextValue < this.iMinValue) {
                this.iCurrentValue = this.iMinValue;
                this.txtValue.setText(String.valueOf(this.iMinValue));
            }
        } else if (oSource.equals(this.btnDecrement)) {
            if (this.iCurrentValue > this.iMinValue && iTextValue > this.iMinValue && iTextValue <= this.iMaxValue) {
                this.iCurrentValue = iTextValue - this.iIncrement;
                this.txtValue.setText(String.valueOf(this.iCurrentValue));
            } else if (this.iCurrentValue > this.iMaxValue) {
                this.iCurrentValue = this.iMaxValue;
                this.txtValue.setText(String.valueOf(this.iMaxValue));
            }
        }
        this.fireValueChangedEvent();
    }

    protected void fireValueChangedEvent() {
        int iL = 0;
        while (iL < this.vListeners.size()) {
            Event se = new Event();
            se.widget = this;
            se.data = this.iCurrentValue;
            se.type = 1;
            se.detail = ChartUIExtensionUtil.PROPERTY_UPDATE;
            this.vListeners.get(iL).handleEvent(se);
            ++iL;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Point getPreferredSize() {
        return new Point(80, 24);
    }

    public void handleEvent(Event event) {
        block12: {
            if (event.type == 0) {
                try {
                    int iValue = Integer.parseInt(this.txtValue.getText());
                    if (iValue >= this.iMinValue && iValue <= this.iMaxValue) {
                        this.iCurrentValue = iValue;
                        this.fireValueChangedEvent();
                        break block12;
                    }
                    this.txtValue.setText(String.valueOf(this.iCurrentValue));
                }
                catch (NumberFormatException e1) {
                    this.txtValue.setText(String.valueOf(this.iCurrentValue));
                }
            } else if (event.type == 1) {
                int iValue = this.iCurrentValue;
                if (event.keyCode == 0x1000001) {
                    iValue = event.stateMask == 262144 ? (iValue += this.iIncrement * 10) : (iValue += this.iIncrement);
                } else if (event.keyCode == 0x1000002) {
                    iValue = event.stateMask == 262144 ? (iValue -= this.iIncrement * 10) : (iValue -= this.iIncrement);
                }
                if (iValue < this.iMinValue) {
                    iValue = this.iMinValue;
                } else if (iValue > this.iMaxValue) {
                    iValue = this.iMaxValue;
                }
                this.iCurrentValue = iValue;
                this.txtValue.setText(String.valueOf(this.iCurrentValue));
                this.fireValueChangedEvent();
            }
        }
    }

    public void setToolTipText(String string) {
        this.txtValue.setToolTipText(string);
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = IntegerSpinControl.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = IntegerSpinControl.this.toControl(new Point(e.x, e.y));
                if (IntegerSpinControl.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = IntegerSpinControl.this.getBounds();
                Point pt = IntegerSpinControl.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }

    private class InternalLayout
    extends Layout {
        private InternalLayout() {
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point textBoxSize = IntegerSpinControl.this.txtValue.computeSize(-1, -1, force);
            Point incButtonSize = IntegerSpinControl.this.btnIncrement.computeSize(-1, -1, force);
            Point decButtonSize = IntegerSpinControl.this.btnDecrement.computeSize(-1, -1, force);
            return new Point(textBoxSize.x + incButtonSize.x + decButtonSize.x, Math.max(textBoxSize.y, incButtonSize.y));
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point textBoxSize = IntegerSpinControl.this.txtValue.computeSize(-1, -1, force);
            Point incButtonSize = IntegerSpinControl.this.btnIncrement.computeSize(-1, -1, force);
            Point decButtonSize = IntegerSpinControl.this.btnDecrement.computeSize(-1, -1, force);
            int maxButtonWidth = Math.max(incButtonSize.x, decButtonSize.x);
            IntegerSpinControl.this.btnDecrement.setBounds(0, 0, maxButtonWidth, bounds.height);
            IntegerSpinControl.this.txtValue.setBounds(maxButtonWidth, 0, bounds.width - maxButtonWidth * 2, bounds.height);
            IntegerSpinControl.this.btnIncrement.setBounds(bounds.width - maxButtonWidth, 0, maxButtonWidth, bounds.height);
        }
    }
}

