/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import com.ibm.icu.util.ULocale;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.swing.ShapedAction;
import org.eclipse.birt.chart.device.swing.SwingHelper;
import org.eclipse.birt.chart.device.util.DeviceUtil;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.Cursor;
import org.eclipse.birt.chart.model.attribute.CursorType;
import org.eclipse.birt.chart.model.attribute.EmbeddedImage;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.render.InteractiveRenderer;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.emf.common.util.EList;

public final class SwingEventHandler
implements MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swing");
    private Action acTooltip = null;
    private final Map<TriggerCondition, List<ShapedAction>> lhmAllTriggers;
    private final IUpdateNotifier iun;
    private final ULocale lcl;
    private InteractiveRenderer iv = null;
    private StructureSource srcHighlight;
    private StructureSource srcToggleDataPoint;
    private StructureSource srcToggleVisibility;
    private JPopupMenu popupMenu;

    SwingEventHandler(InteractiveRenderer iv, Map<TriggerCondition, List<ShapedAction>> _lhmAllTriggers, IUpdateNotifier _jc, ULocale _lcl) {
        this.lhmAllTriggers = _lhmAllTriggers;
        this.iun = _jc;
        this.lcl = _lcl;
        this.iv = iv;
    }

    private boolean isLeftButton(MouseEvent e) {
        return e.getButton() == 1;
    }

    private ShapedAction getShapedActionForConditionPoint(TriggerCondition[] tca, Point p) {
        if (tca == null || tca.length == 0) {
            return null;
        }
        int i = 0;
        while (i < tca.length) {
            List<ShapedAction> tal = this.lhmAllTriggers.get(tca[i]);
            if (tal != null) {
                int j = tal.size() - 1;
                while (j >= 0) {
                    ShapedAction sa = tal.get(j);
                    if (p == null || sa.getShape().contains(p)) {
                        return sa;
                    }
                    --j;
                }
            }
            ++i;
        }
        return null;
    }

    private void handleAction(TriggerCondition[] tg, ComponentEvent event) {
        this.handleAction(tg, event, true);
    }

    private synchronized void handleAction(TriggerCondition[] tg, ComponentEvent event, boolean cleanState) {
        if (tg == null || event == null) {
            return;
        }
        Point p = null;
        if (event instanceof MouseEvent) {
            p = ((MouseEvent)event).getPoint();
        }
        boolean cfr_ignored_0 = event instanceof KeyEvent;
        ShapedAction sa = this.getShapedActionForConditionPoint(tg, p);
        if (sa == null) {
            int i = 0;
            while (i < tg.length) {
                if (this.lhmAllTriggers.get(tg[i]) != null) {
                    this.disableActions(this.getActionTypesForConditions(tg));
                }
                ++i;
            }
            return;
        }
        StructureSource src = sa.getSource();
        Action ac = null;
        int i = 0;
        while (i < tg.length) {
            ac = sa.getActionForCondition(tg[i]);
            if (ac != null) break;
            ++i;
        }
        if (ac == null) {
            return;
        }
        switch (ac.getType().getValue()) {
            case 0: {
                MultiURLValues muv;
                int size;
                ActionValue av = ac.getValue();
                if (av instanceof URLValue) {
                    URLValue uv = (URLValue)ac.getValue();
                    this.openURL(uv);
                    break;
                }
                if (!(av instanceof MultiURLValues) || (size = (muv = (MultiURLValues)av).getURLValues().size()) == 0) break;
                if (size == 1) {
                    this.openURL((URLValue)muv.getURLValues().get(0));
                    break;
                }
                this.openMultiULRs(muv, p);
                break;
            }
            case 1: {
                if (ac != this.acTooltip) {
                    this.hideTooltip();
                }
                this.acTooltip = ac;
                this.showTooltip(ac);
                break;
            }
            case 2: {
                this.srcToggleVisibility = this.handleGraphicAction(src, this.srcToggleVisibility, ActionType.TOGGLE_VISIBILITY_LITERAL, cleanState);
                break;
            }
            case 6: {
                this.srcToggleDataPoint = this.handleGraphicAction(src, this.srcToggleDataPoint, ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL, cleanState);
                break;
            }
            case 4: {
                this.srcHighlight = this.handleGraphicAction(src, this.srcHighlight, ActionType.HIGHLIGHT_LITERAL, cleanState);
                break;
            }
            case 5: {
                if (this.iun instanceof ICallBackNotifier) {
                    CallBackValue cv = (CallBackValue)ac.getValue();
                    ((ICallBackNotifier)this.iun).callback((Object)event, (Object)sa.getSource(), cv);
                    break;
                }
                logger.log(2, Messages.getString("SwingEventHandler.info.improper.callback.notifier", new Object[]{this.iun}, this.lcl));
            }
        }
    }

    private void openMultiULRs(MultiURLValues muv, Point point) {
        if (this.popupMenu != null && this.popupMenu.isValid()) {
            this.popupMenu.setVisible(false);
            ((JComponent)this.iun.peerInstance()).remove(this.popupMenu);
        }
        this.popupMenu = new JPopupMenu();
        for (URLValue uv : muv.getURLValues()) {
            JMenuItem menuItem = new JMenuItem();
            this.popupMenu.add(menuItem);
            menuItem.setText(uv.getLabel().getCaption().getValue());
            if (uv.getTooltip() != null && uv.getTooltip().length() > 0) {
                menuItem.setToolTipText(uv.getTooltip());
            }
            URLMenuItemModel uim = new URLMenuItemModel();
            uim.setURLValue(uv);
            menuItem.setModel(uim);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URLValue urlValue = ((URLMenuItemModel)((JMenuItem)e.getSource()).getModel()).getURLValue();
                    SwingEventHandler.this.openURL(urlValue);
                }
            });
        }
        this.popupMenu.show((JComponent)this.iun.peerInstance(), point.x, point.y);
    }

    private void openURL(URLValue uv) {
        logger.log(1, Messages.getString("SwingEventHandler.info.redirect.url", this.lcl) + uv.getBaseUrl());
        DeviceUtil.openURL(uv.getBaseUrl());
    }

    private void disableActions(Set<ActionType> actions) {
        if (actions == null) {
            return;
        }
        for (ActionType action : actions) {
            if (action == null) continue;
            switch (action.getValue()) {
                case 1: {
                    if (this.acTooltip == null) break;
                    this.hideTooltip();
                    this.acTooltip = null;
                    break;
                }
                case 4: {
                    if (this.srcHighlight == null) break;
                    this.iv.unregisterAction(this.srcHighlight, ActionType.HIGHLIGHT_LITERAL);
                    this.srcHighlight = null;
                    this.iun.repaintChart();
                    break;
                }
                case 6: {
                    if (this.srcToggleDataPoint == null) break;
                    this.iv.unregisterAction(this.srcToggleDataPoint, ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL);
                    this.srcToggleDataPoint = null;
                    this.iun.repaintChart();
                    break;
                }
                case 2: {
                    if (this.srcToggleVisibility == null) break;
                    this.iv.unregisterAction(this.srcToggleVisibility, ActionType.TOGGLE_VISIBILITY_LITERAL);
                    this.srcToggleVisibility = null;
                    this.iun.repaintChart();
                }
            }
        }
    }

    private StructureSource handleGraphicAction(StructureSource src, StructureSource previousSrc, ActionType actionType, boolean cleanState) {
        if (previousSrc == null) {
            previousSrc = src;
            this.iv.registerAction(src, actionType);
            this.iun.repaintChart();
        } else if (!this.iv.getSource(src).equals(this.iv.getSource(previousSrc))) {
            if (actionType == ActionType.HIGHLIGHT_LITERAL) {
                this.iv.unregisterAction(previousSrc, actionType);
                previousSrc = src;
                this.iv.registerAction(src, actionType);
            } else {
                previousSrc = src;
                if (this.iv.isRegisteredAction(src, actionType)) {
                    this.iv.unregisterAction(src, actionType);
                } else {
                    this.iv.registerAction(src, actionType);
                }
            }
            this.iun.repaintChart();
        } else if (cleanState) {
            this.iv.unregisterAction(previousSrc, actionType);
            previousSrc = null;
            this.iun.repaintChart();
        }
        return previousSrc;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isLeftButton(e)) {
            this.handleAction(new TriggerCondition[]{TriggerCondition.MOUSE_CLICK_LITERAL, TriggerCondition.ONCLICK_LITERAL}, e);
        } else {
            this.handleAction(new TriggerCondition[]{TriggerCondition.ONRIGHTCLICK_LITERAL}, e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONMOUSEOUT_LITERAL}, e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONMOUSEDOWN_LITERAL}, e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONMOUSEUP_LITERAL}, e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        ShapedAction sa = this.getShapedActionForConditionPoint(new TriggerCondition[]{TriggerCondition.MOUSE_CLICK_LITERAL, TriggerCondition.ONCLICK_LITERAL, TriggerCondition.ONMOUSEDOWN_LITERAL, TriggerCondition.ONMOUSEOVER_LITERAL, TriggerCondition.ONMOUSEMOVE_LITERAL}, p);
        if (sa != null) {
            this.setCursor((JComponent)this.iun.peerInstance(), sa.getCursor(), java.awt.Cursor.getDefaultCursor());
        } else {
            this.setCursor((JComponent)this.iun.peerInstance(), null, java.awt.Cursor.getDefaultCursor());
        }
        this.handleAction(new TriggerCondition[]{TriggerCondition.MOUSE_HOVER_LITERAL, TriggerCondition.ONMOUSEMOVE_LITERAL, TriggerCondition.ONMOUSEOVER_LITERAL}, e, false);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONFOCUS_LITERAL}, e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONBLUR_LITERAL}, e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONKEYDOWN_LITERAL}, e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONKEYUP_LITERAL, TriggerCondition.ONKEYPRESS_LITERAL}, e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void hideTooltip() {
        ((JComponent)this.iun.peerInstance()).setToolTipText(null);
    }

    private void showTooltip(Action ac) {
        TooltipValue tv = (TooltipValue)ac.getValue();
        if (tv.getText() == null) {
            return;
        }
        Object tooltip = tv.getText().replaceAll("\\\n", "<br>");
        tooltip = !((String)tooltip).equals(tv.getText()) ? "<html>" + (String)tooltip + "</html>" : tv.getText();
        ((JComponent)this.iun.peerInstance()).setToolTipText((String)tooltip);
    }

    protected Set<ActionType> getActionTypesForConditions(TriggerCondition[] tca) {
        if (tca == null || tca.length == 0) {
            return null;
        }
        HashSet<ActionType> set = new HashSet<ActionType>();
        int i = 0;
        while (i < tca.length) {
            List<ShapedAction> tal = this.lhmAllTriggers.get(tca[i]);
            if (tal != null) {
                for (ShapedAction sa : tal) {
                    ActionType actionType = sa.getActionForCondition(tca[i]).getType();
                    set.add(actionType);
                }
            }
            ++i;
        }
        return set;
    }

    private void setCursor(JComponent composite, Cursor cursor, java.awt.Cursor defaultCursor) {
        if (cursor == null || cursor.getType() == CursorType.AUTO) {
            composite.setCursor(defaultCursor);
            return;
        }
        if (cursor.getType() == CursorType.CUSTOM) {
            EList uris = cursor.getImage();
            for (Image uri : uris) {
                try {
                    java.awt.Image image = null;
                    if (uri instanceof EmbeddedImage) {
                        try {
                            byte[] data = Base64.decodeBase64((byte[])((EmbeddedImage)uri).getData().getBytes());
                            image = new ImageIcon(data).getImage();
                        }
                        catch (Exception ilex) {
                            logger.log(ilex);
                        }
                    } else {
                        URI u = new URI(uri.getURL());
                        image = composite.getToolkit().createImage(SecurityUtil.toURL((URI)u));
                    }
                    if (image == null) continue;
                    composite.setCursor(composite.getToolkit().createCustomCursor(image, new Point(0, 0), ""));
                    return;
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
            }
            composite.setCursor(defaultCursor);
            return;
        }
        composite.setCursor(java.awt.Cursor.getPredefinedCursor(SwingHelper.CURSOR_MAP.get(cursor.getType())));
    }

    static class URLMenuItemModel
    extends DefaultButtonModel {
        private static final long serialVersionUID = 1L;
        private URLValue fUrlValue;

        URLMenuItemModel() {
        }

        void setURLValue(URLValue uv) {
            this.fUrlValue = uv;
        }

        URLValue getURLValue() {
            return this.fUrlValue;
        }
    }
}

