/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl.rank;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.rank.RankAggregationUtil;
import org.eclipse.birt.data.engine.core.DataException;

abstract class PercentileAccumulator
extends SummaryAccumulator {
    private Double pct;
    private List cachedValues;

    public PercentileAccumulator(ICalculator calc) {
        super(calc);
    }

    @Override
    public void start() {
        super.start();
        this.pct = -1.0;
        this.cachedValues = new ArrayList();
    }

    public void onRow(Object[] args) throws DataException {
        Number d;
        assert (args.length == 2);
        if (args[0] != null && (d = this.calculator.add(this.calculator.getTypedObject(0), this.calculator.getTypedObject(args[0]))) != null) {
            this.cachedValues.add(d);
        }
        if (this.pct == -1.0) {
            Double pctValue = RankAggregationUtil.getNumericValue(args[1]);
            this.pct = this.getPctValue(pctValue);
        }
    }

    protected abstract double getPctValue(Double var1) throws DataException;

    @Override
    public Object getSummaryValue() throws DataException {
        Object[] sortedObjs = this.cachedValues.toArray();
        if (sortedObjs.length == 0) {
            return null;
        }
        RankAggregationUtil.sortArray(sortedObjs);
        double n = this.pct * (double)(sortedObjs.length - 1) + 1.0;
        int k = (int)Math.floor(n);
        double fraction = n - (double)k;
        Number adjustment = 0;
        if (fraction != 0.0) {
            adjustment = this.calculator.multiply(this.calculator.getTypedObject(fraction), this.calculator.subtract(this.calculator.getTypedObject(sortedObjs[k]), this.calculator.getTypedObject(sortedObjs[k - 1])));
        }
        return this.calculator.add(this.calculator.getTypedObject(sortedObjs[k - 1]), this.calculator.getTypedObject(adjustment));
    }
}

