/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTreeViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

class StartLevelEditingSupport
extends EditingSupport {
    private final CachedCheckboxTreeViewer fViewer;
    private final CellEditor fCellEditor;

    public StartLevelEditingSupport(CachedCheckboxTreeViewer viewer) {
        super((ColumnViewer)viewer);
        this.fViewer = viewer;
        this.fCellEditor = new StartLevelCellEditor((Composite)viewer.getTree());
    }

    protected CellEditor getCellEditor(Object element) {
        return this.fCellEditor;
    }

    protected boolean canEdit(Object element) {
        return this.fViewer.isCheckedLeafElement(element) && element instanceof IHasStartLevel;
    }

    protected Object getValue(Object element) {
        return ((IHasStartLevel)element).getStartLevel();
    }

    protected void setValue(Object element, Object value) {
        ((IHasStartLevel)element).setStartLevel((String)value);
        this.fViewer.update(element, null);
    }

    public static interface IHasStartLevel {
        public String getStartLevel();

        public void setStartLevel(String var1);
    }

    private static class StartLevelCellEditor
    extends CellEditor {
        private Spinner fSpinner;

        public StartLevelCellEditor(Composite parent) {
            this.create(parent);
        }

        protected Control createControl(Composite parent) {
            this.fSpinner = new Spinner(parent, 2048);
            this.fSpinner.setMinimum(0);
            this.fSpinner.addTraverseListener(e -> {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            });
            this.fSpinner.addSelectionListener(SelectionListener.widgetDefaultSelectedAdapter(e -> {
                this.fireApplyEditorValue();
                this.deactivate();
            }));
            this.fSpinner.addKeyListener(KeyListener.keyReleasedAdapter(e -> {
                if (e.character == '\u001b') {
                    this.fireCancelEditor();
                }
            }));
            return this.fSpinner;
        }

        protected Object doGetValue() {
            int startLevel = this.fSpinner.getSelection();
            return startLevel > 0 ? String.valueOf(startLevel) : "default";
        }

        protected void doSetFocus() {
            this.fSpinner.setFocus();
        }

        protected void doSetValue(Object value) {
            if (value == null || "default".equals(value)) {
                this.fSpinner.setSelection(0);
            } else {
                this.fSpinner.setSelection(Integer.parseInt((String)value));
            }
        }
    }
}

