/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.parameter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.ui.preview.parameter.IParameter;
import org.eclipse.birt.report.designer.ui.preview.parameter.ScalarParam;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;

public abstract class ListingParam
extends ScalarParam {
    public ListingParam(ScalarParameterHandle handle, IEngineTask engineTask) {
        super(handle, engineTask);
    }

    @Override
    public List getValueList() {
        List values = new ArrayList();
        boolean isCascading = this.isCascadingParameter();
        String name = this.handle.getName();
        IGetParameterDefinitionTask task = this.engineTask.getEngine().createGetParameterDefinitionTask(this.engineTask.getReportRunnable());
        if (isCascading) {
            values = this.getCascadingValues(values, task);
        } else {
            List selectionList = (List)task.getSelectionList(name);
            values.addAll(selectionList);
        }
        return values;
    }

    private List getCascadingValues(List values, IGetParameterDefinitionTask task) {
        CascadingParameterGroupHandle container = (CascadingParameterGroupHandle)this.handle.getContainer();
        ArrayList<Object> groupList = new ArrayList<Object>();
        List children = this.group.getChildren();
        for (IParameter param : children) {
            if (param == this) break;
            String value = param.getSelectionValue();
            try {
                groupList.add(param.converToDataType(value));
            }
            catch (BirtException birtException) {
                // empty catch block
            }
        }
        Object[] groupKeys = new Object[groupList.size()];
        int i = 0;
        while (i < groupList.size()) {
            groupKeys[i] = groupList.get(i);
            ++i;
        }
        List cascading = (List)task.getSelectionListForCascadingGroup(container.getName(), groupKeys);
        return cascading;
    }

    private boolean isCascadingParameter() {
        DesignElementHandle container = this.handle.getContainer();
        return container instanceof CascadingParameterGroupHandle;
    }
}

