/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.AccordionLabel;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.AccordionSubComposite;
import org.eclipse.birt.report.designer.internal.ui.util.UIHelper;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class AccordionControl
extends Composite {
    private static final int ITEM_SPACING = 0;
    private static final String KEY_CONTENT = "content";
    private static final String KEY_HEADER = "header";
    private Image mClosed;
    private Image mOpen;
    private boolean mSingle = true;
    private boolean mWrap;
    public static final Image ICON_COLLAPSE = UIHelper.getImage(ReportPlugin.getDefault().getBundle(), "icons/obj16/collapse.png");
    public static final Image ICON_EXPAND = UIHelper.getImage(ReportPlugin.getDefault().getBundle(), "icons/obj16/expand.png");

    protected Composite createChildContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        if (this.mWrap) {
            RowLayout layout = new RowLayout(256);
            layout.center = true;
            composite.setLayout((Layout)layout);
        } else {
            RowLayout layout = new RowLayout(512);
            layout.spacing = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginRight = 0;
            layout.marginBottom = 0;
            composite.setLayout((Layout)layout);
        }
        return composite;
    }

    protected abstract void createChildren(Composite var1, Object var2);

    public void setAutoClose(boolean single) {
        this.mSingle = single;
    }

    public boolean isAutoClose() {
        return this.mSingle;
    }

    public List<AccordionLabel> getHeaderLabels() {
        ArrayList<AccordionLabel> headers = new ArrayList<AccordionLabel>();
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof AccordionLabel) {
                headers.add((AccordionLabel)c);
            }
            ++n2;
        }
        return headers;
    }

    public void expandAll(boolean performLayout) {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof AccordionLabel && !this.isOpen(c)) {
                this.toggle((AccordionLabel)c, false, false);
            }
            ++n2;
        }
        if (performLayout) {
            this.pack();
            this.layout();
        }
    }

    public void collapseAll(boolean performLayout) {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof AccordionLabel && this.isOpen(c)) {
                this.toggle((AccordionLabel)c, false, false);
            }
            ++n2;
        }
        if (performLayout) {
            this.layout();
        }
    }

    public AccordionControl(Composite parent, int style, List<?> headers, boolean greedy, boolean wrapChildren) {
        super(parent, style);
        this.mWrap = wrapChildren;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 1;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 4;
        gridLayout.marginHeight = 5;
        this.setLayout((Layout)gridLayout);
        Font labelFont = null;
        this.mOpen = ICON_EXPAND;
        this.mClosed = ICON_COLLAPSE;
        ArrayList<AccordionLabel> expandLabels = new ArrayList<AccordionLabel>();
        int i = 0;
        while (i < headers.size()) {
            Object header = headers.get(i);
            final AccordionLabel label = new AccordionLabel(this, 64);
            GridLayout gl = new GridLayout();
            gl.marginHeight = 0;
            label.setLayout((Layout)gl);
            label.setAction(this.getHeaderAction(header));
            label.setText(this.getHeaderTitle(header).replace("&", "&&"));
            this.updateBackground(label, false);
            if (labelFont == null) {
                labelFont = label.getFont();
                FontData normal = labelFont.getFontData()[0];
                FontData bold = new FontData(normal.getName(), normal.getHeight(), 1);
                labelFont = new Font(null, bold);
            }
            label.setFont(labelFont);
            GridData gd = new GridData(4, 0x1000000, true, false, 1, 1);
            if (i > 0) {
                gd.verticalIndent = 5;
            }
            label.setLayoutData(gd);
            this.setHeader(header, label);
            label.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (e.button == 1 && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
                        if (label.isActionArea(e.x, e.y)) {
                            if (label.getAction() != null) {
                                label.getAction().run();
                            }
                        } else {
                            AccordionControl.this.toggle(label, true, AccordionControl.this.mSingle);
                        }
                    }
                }
            });
            label.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    AccordionControl.this.updateBackground(label, true);
                }

                public void mouseExit(MouseEvent e) {
                    AccordionControl.this.updateBackground(label, false);
                }

                public void mouseHover(MouseEvent e) {
                }
            });
            final AccordionSubComposite scrolledComposite = new AccordionSubComposite(this, 576);
            ScrollBar verticalBar = scrolledComposite.getVerticalBar();
            verticalBar.setIncrement(20);
            verticalBar.setPageIncrement(100);
            this.setContentArea(label, scrolledComposite);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            GridData scrollGridData = new GridData(4, greedy ? 4 : 128, false, greedy, 1, 1);
            scrollGridData.exclude = true;
            scrollGridData.grabExcessHorizontalSpace = wrapChildren;
            scrolledComposite.setLayoutData(scrollGridData);
            if (wrapChildren) {
                scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        Rectangle r = scrolledComposite.getClientArea();
                        Control content = scrolledComposite.getContent();
                        if (content != null && r != null) {
                            Point minSize = content.computeSize(r.width, -1);
                            scrolledComposite.setMinSize(minSize);
                            ScrollBar vBar = scrolledComposite.getVerticalBar();
                            vBar.setPageIncrement(r.height);
                        }
                    }
                });
            }
            this.updateIcon(label);
            if (this.getHeaderExpandStatus(header)) {
                expandLabels.add(label);
            }
            ++i;
        }
        for (AccordionLabel label : expandLabels) {
            this.toggle(label, false, false);
        }
    }

    public abstract IAction getHeaderAction(Object var1);

    public abstract String getHeaderTitle(Object var1);

    public abstract boolean getHeaderExpandStatus(Object var1);

    private void updateBackground(AccordionLabel label, boolean mouseOver) {
        Display display = label.getDisplay();
        label.setBackground(new Color[]{display.getSystemColor(20), display.getSystemColor(20), display.getSystemColor(19)}, new int[]{mouseOver ? 40 : 20, 100}, true);
    }

    public void refresh() {
        int i = 0;
        while (i < this.getHeaderLabels().size()) {
            AccordionLabel label = this.getHeaderLabels().get(i);
            String text = this.getHeaderTitle(label.getData(KEY_HEADER));
            if (text != null && text.trim().length() > 0) {
                label.setText(text.replace("&", "&&"));
            }
            this.updateBackground(label, false);
            ++i;
        }
    }

    private void updateIcon(AccordionLabel label) {
        label.setImage(this.isOpen((Control)label) ? this.mOpen : this.mClosed);
    }

    private boolean isOpen(Control label) {
        if (this.getContentArea(label) == null) {
            return false;
        }
        return !((GridData)this.getContentArea((Control)label).getLayoutData()).exclude;
    }

    private void toggle(AccordionLabel label, boolean performLayout, boolean autoClose) {
        boolean close;
        if (autoClose) {
            this.collapseAll(true);
        }
        ScrolledComposite scrolledComposite = this.getContentArea((Control)label);
        GridData scrollGridData = (GridData)scrolledComposite.getLayoutData();
        scrollGridData.exclude = close = !scrollGridData.exclude;
        scrolledComposite.setVisible(!close);
        this.updateIcon(label);
        if (!scrollGridData.exclude && scrolledComposite.getContent() == null) {
            Composite composite = this.createChildContainer((Composite)scrolledComposite);
            Object header = this.getHeader((Control)label);
            this.createChildren(composite, header);
            scrolledComposite.setContent((Control)composite);
            scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        }
        if (performLayout) {
            this.layout(true);
        }
        Event event = new Event();
        event.widget = this;
        this.notifyListeners(2, event);
    }

    private Object getHeader(Control label) {
        return label.getData(KEY_HEADER);
    }

    private void setHeader(Object header, AccordionLabel label) {
        label.setData(KEY_HEADER, header);
    }

    private ScrolledComposite getContentArea(Control label) {
        return (ScrolledComposite)label.getData(KEY_CONTENT);
    }

    private void setContentArea(AccordionLabel label, ScrolledComposite scrolledComposite) {
        label.setData(KEY_CONTENT, scrolledComposite);
    }

    protected void checkSubclass() {
    }

    public List getExpandedCategories() {
        ArrayList<Object> expanded = new ArrayList<Object>();
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof AccordionLabel && this.isOpen(c)) {
                expanded.add(((AccordionLabel)c).getData(KEY_HEADER));
            }
            ++n2;
        }
        return expanded;
    }
}

