/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import java.util.Iterator;
import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class ColumnHandleAdapter
extends DesignElementHandleAdapter {
    public static final int DEFAULT_MINWIDTH = 20;

    public ColumnHandleAdapter(ColumnHandle column) {
        this(column, null);
    }

    public ColumnHandleAdapter(ColumnHandle column, IModelAdapterHelper mark) {
        super((DesignElementHandle)column, mark);
    }

    public int getWidth() {
        Object obj;
        DimensionHandle handle = this.getColumnHandle().getWidth();
        if ("%".equals(handle.getUnits()) && (obj = (obj = this.getTableParent()) instanceof GridHandle ? HandleAdapterFactory.getInstance().getGridHandleAdapter(obj) : HandleAdapterFactory.getInstance().getTableHandleAdapter(obj)) instanceof TableHandleAdapter) {
            int containerWidth = ((TableHandleAdapter)obj).getClientAreaSize().width;
            return (int)(handle.getMeasure() * (double)containerWidth / 100.0);
        }
        int px = (int)DEUtil.convertoToPixel(handle);
        if (px <= 0) {
            if (handle.isSet()) {
                return 1;
            }
            TableHandleAdapter adapter = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableParent());
            return adapter.getDefaultWidth(this.getColumnNumber());
        }
        return px;
    }

    public String getRawWidth() {
        DimensionHandle handle = this.getColumnHandle().getWidth();
        String unit = handle.getUnits();
        if (unit == null || unit.length() == 0) {
            return "";
        }
        if (unit.equals("%")) {
            return String.valueOf(handle.getMeasure()) + unit;
        }
        int px = (int)DEUtil.convertoToPixel(handle);
        if (px <= 0) {
            if (handle.isSet()) {
                px = 1;
            } else {
                TableHandleAdapter adapter = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableParent());
                return String.valueOf(adapter.getDefaultWidth(this.getColumnNumber()));
            }
        }
        return String.valueOf(px);
    }

    public boolean isCustomWidth() {
        DimensionHandle handle = this.getColumnHandle().getWidth();
        return handle.getMeasure() > 0.0;
    }

    public int getColumnNumber() {
        TableHandleAdapter adapter = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableParent());
        return adapter.getColumns().indexOf(this.getColumnHandle()) + 1;
    }

    public Object getTableParent() {
        DesignElementHandle element = this.getColumnHandle().getContainer();
        if (element instanceof TableGroupHandle) {
            element = element.getContainer();
        }
        return element;
    }

    private ColumnHandle getColumnHandle() {
        return (ColumnHandle)this.getHandle();
    }

    public void setWidth(int columnWidth, String units) throws SemanticException {
        MetricUtility.updateDimension(this.getColumnHandle().getWidth(), columnWidth, units);
    }

    public void setWidth(int columnWidth) throws SemanticException {
        MetricUtility.updateDimension(this.getColumnHandle().getWidth(), columnWidth);
    }

    public Object copy() throws SemanticException {
        SlotHandle slotHandle = this.getColumnHandle().getContainerSlotHandle();
        ColumnHandle retValue = slotHandle.getElementHandle().getElementFactory().newTableColumn();
        Iterator iter = this.getColumnHandle().getPropertyIterator();
        while (iter.hasNext()) {
            PropertyHandle handle = (PropertyHandle)iter.next();
            String key = handle.getDefn().getName();
            if (!handle.isLocal()) continue;
            this.getColumnHandle().copyPropertyTo(key, (DesignElementHandle)retValue);
        }
        return retValue;
    }
}

