/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.NameEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataSource;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ContentIterator;

public class NameRecord
extends SimpleRecord {
    protected DesignElement element = null;
    protected String newName = null;
    protected String oldName = null;

    public NameRecord(DesignElement obj, String name) {
        this.element = obj;
        this.newName = name;
        this.oldName = this.element.getName();
        this.label = CommandLabelFactory.getCommandLabel("Message.SetName");
    }

    @Override
    protected void perform(boolean undo) {
        Module root;
        this.element.setName(undo ? this.oldName : this.newName);
        this.updateSharedDimension(this.element.getRoot(), this.element);
        if (this.element instanceof DataSource && (root = this.element.getRoot()) != null) {
            if (undo) {
                root.updateCacheForRename((DataSource)this.element, this.newName, this.oldName);
            } else {
                root.updateCacheForRename((DataSource)this.element, this.oldName, this.newName);
            }
        }
        if (this.element instanceof MasterPage && (root = this.element.getRoot()) != null) {
            if (undo) {
                this.updatePropertyForRename(root, "masterPage", this.newName, this.oldName);
            } else {
                this.updatePropertyForRename(root, "masterPage", this.oldName, this.newName);
            }
        }
    }

    private void updatePropertyForRename(Module root, String propName, String oldName, String newName) {
        ContentIterator iterator = new ContentIterator(root, root);
        while (iterator.hasNext()) {
            DesignElement elem = iterator.next();
            Object prop = elem.getProperty(root, propName);
            if (prop == null || !prop.equals(oldName)) continue;
            elem.setProperty(propName, (Object)newName);
        }
    }

    @Override
    public DesignElement getTarget() {
        return this.element;
    }

    @Override
    public NotificationEvent getEvent() {
        return new NameEvent(this.element, this.oldName, this.newName);
    }

    @Override
    protected List<RecordTask> getPostTasks() {
        ArrayList<RecordTask> retValue = new ArrayList<RecordTask>(super.getPostTasks());
        NameEvent event = new NameEvent(this.element, this.oldName, this.newName);
        DesignElement e = this.element;
        this.sendEventToSharedDimension(e, retValue, event);
        return retValue;
    }
}

