/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.Subgraph;

class NestingTree {
    List<Object> contents = new ArrayList<Object>();
    boolean isLeaf = true;
    int size;
    double sortValue;
    Node subgraph;

    NestingTree() {
    }

    private static void addToNestingTree(Map<Subgraph, NestingTree> map, Node child) {
        Subgraph subgraph = child.getParent();
        NestingTree parent = map.get(subgraph);
        if (parent == null) {
            parent = new NestingTree();
            parent.subgraph = subgraph;
            map.put(subgraph, parent);
            if (subgraph != null) {
                NestingTree.addToNestingTree(map, parent);
            }
        }
        parent.contents.add(child);
    }

    private static void addToNestingTree(Map<Subgraph, NestingTree> map, NestingTree branch) {
        Subgraph subgraph = branch.subgraph.getParent();
        NestingTree parent = map.get(subgraph);
        if (parent == null) {
            parent = new NestingTree();
            parent.subgraph = subgraph;
            map.put(subgraph, parent);
            if (subgraph != null) {
                NestingTree.addToNestingTree(map, parent);
            }
        }
        parent.contents.add(branch);
    }

    static NestingTree buildNestingTreeForRank(Rank rank) {
        HashMap<Subgraph, NestingTree> nestingMap = new HashMap<Subgraph, NestingTree>();
        int j = 0;
        while (j < rank.count()) {
            Node node = (Node)rank.get(j);
            NestingTree.addToNestingTree(nestingMap, node);
            ++j;
        }
        return (NestingTree)nestingMap.get(null);
    }

    /*
     * WARNING - void declaration
     */
    void calculateSortValues() {
        int total = 0;
        for (Object o : this.contents) {
            Object object = o;
            if (object instanceof NestingTree) {
                void e;
                NestingTree cfr_ignored_0 = (NestingTree)object;
                NestingTree cfr_ignored_1 = (NestingTree)object;
                this.isLeaf = false;
                e.calculateSortValues();
                total += (int)(e.sortValue * (double)e.size);
                this.size += e.size;
                continue;
            }
            Node n = (Node)o;
            n.sortValue = n.index;
            total += n.index;
            ++this.size;
        }
        this.sortValue = (double)total / (double)this.size;
    }

    void getSortValueFromSubgraph() {
        if (this.subgraph != null) {
            this.sortValue = this.subgraph.sortValue;
        }
        for (Object o : this.contents) {
            if (!(o instanceof NestingTree)) continue;
            ((NestingTree)o).getSortValueFromSubgraph();
        }
    }

    /*
     * WARNING - void declaration
     */
    void recursiveSort(boolean sortLeaves) {
        if (this.isLeaf && !sortLeaves) {
            return;
        }
        boolean change = false;
        do {
            change = false;
            int i = 0;
            while (i < this.contents.size() - 1) {
                change |= this.swap(i);
                ++i;
            }
            if (!change) break;
            change = false;
            i = this.contents.size() - 2;
            while (i >= 0) {
                change |= this.swap(i);
                --i;
            }
        } while (change);
        for (Object o : this.contents) {
            void nt;
            Object object = o;
            if (!(object instanceof NestingTree)) continue;
            NestingTree cfr_ignored_0 = (NestingTree)object;
            NestingTree cfr_ignored_1 = (NestingTree)object;
            nt.recursiveSort(sortLeaves);
        }
    }

    /*
     * WARNING - void declaration
     */
    void repopulateRank(Rank r) {
        for (Object o : this.contents) {
            Object object = o;
            if (object instanceof Node) {
                void node;
                Node cfr_ignored_0 = (Node)object;
                Node cfr_ignored_1 = (Node)object;
                r.add(node);
                continue;
            }
            ((NestingTree)o).repopulateRank(r);
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean swap(int index) {
        double iR;
        double d;
        Object left = this.contents.get(index);
        Object right = this.contents.get(index + 1);
        Object object = left;
        if (object instanceof Node) {
            void node;
            Node node2 = (Node)object;
            Node cfr_ignored_0 = (Node)object;
            d = node.sortValue;
        } else {
            d = ((NestingTree)left).sortValue;
        }
        double iL = d;
        Object object2 = right;
        if (object2 instanceof Node) {
            void node;
            Node node3 = (Node)object2;
            Node cfr_ignored_1 = (Node)object2;
            v1 = node.sortValue;
        } else {
            v1 = iR = ((NestingTree)right).sortValue;
        }
        if (iL <= iR) {
            return false;
        }
        this.contents.set(index, right);
        this.contents.set(index + 1, left);
        return true;
    }

    public String toString() {
        return "Nesting:" + String.valueOf(this.subgraph);
    }
}

