
/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */


package org.apache.poi.util;

import org.apache.poi.util.LittleEndian.BufferUnderrunException;

import java.io.*;

/**
 * behavior of a field at a fixed location within a byte array
 */

public interface FixedField
{

    /**
     * set the value from its offset into an array of bytes
     *
     * @param data the byte array from which the value is to be read
     *
     * @throws ArrayIndexOutOfBoundsException if the offset is out
     *            of the array's valid index range
     */

    void readFromBytes(byte [] data)
        throws ArrayIndexOutOfBoundsException;

    /**
     * set the value from an InputStream
     *
     * @param stream the InputStream from which the value is to be
     *               read
     *
     * @throws BufferUnderrunException if there is not enough data
     *            available from the InputStream
     * @throws IOException if an IOException is thrown from reading
     *            the InputStream
     */

    void readFromStream(InputStream stream)
        throws IOException;

    /**
     * write the value out to an array of bytes at the appropriate
     * offset
     *
     * @param data the array of bytes to which the value is to be
     *             written
     *
     * @throws ArrayIndexOutOfBoundsException if the offset is out
     *            of the array's valid index range
     */

    void writeToBytes(byte [] data)
        throws ArrayIndexOutOfBoundsException;

    /**
     * return the value as a String
     *
     * @return the value as a String
     */

    String toString();
}   // end public interface FixedField

