/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.dup;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplicateItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplicateUtil;
import org.eclipse.birt.report.engine.internal.executor.wrap.WrappedReportExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.util.FastPool;

public class SuppressDuplciateReportExecutor
extends WrappedReportExecutor {
    private IReportContent report;
    private FastPool executors = new FastPool();
    private SuppressDuplicateUtil suppressUtil;

    public SuppressDuplciateReportExecutor(IReportExecutor executor) {
        super(executor);
    }

    @Override
    public IReportContent execute() throws BirtException {
        if (this.report == null) {
            this.report = super.execute();
            this.suppressUtil = new SuppressDuplicateUtil(this.report.getDesign());
        }
        return this.report;
    }

    void clearDuplicateFlags(IContent content) {
        this.suppressUtil.clearDuplicateFlags(content);
    }

    IContent suppressDuplicate(IContent content) throws BirtException {
        return this.suppressUtil.suppressDuplicate(content);
    }

    @Override
    public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) throws BirtException {
        return this.reportExecutor.createPageExecutor(pageNumber, pageDesign);
    }

    @Override
    protected IReportItemExecutor createWrappedExecutor(IReportItemExecutor executor) {
        SuppressDuplicateItemExecutor wrappedExecutor = null;
        if (this.executors.isEmpty()) {
            wrappedExecutor = new SuppressDuplicateItemExecutor(this, executor);
        } else {
            wrappedExecutor = (SuppressDuplicateItemExecutor)this.executors.remove();
            wrappedExecutor.setExecutor(executor);
        }
        return wrappedExecutor;
    }

    @Override
    protected void closeWrappedExecutor(IReportItemExecutor executor) {
        this.executors.add(executor);
    }
}

