/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.enablement.ibm.util.IPostprocessProvider;
import org.eclipse.datatools.enablement.ibm.util.PostProcessingDescriptor;

public class PostProcessingRegistryReader {
    public static final String NAMESPACE_POST_PROCESSING_EXTENSION_POINT = "com.ibm.datatools.core.postProcess";
    public static final String NAMESPACE_POST_PROCESSING_CLASS = "class";
    public static final String NAMESPACE_POST_PROCESSING_MODEL_TYPE = "modelType";
    public static final String NAMESPACE_POST_PROCESSING_ID = "id";
    public static final String NAMESPACE_POST_PROCESSING_LDM = "LDM";
    private static PostProcessingRegistryReader myInstance;
    private List<PostProcessingDescriptor> extensionProviders;

    private PostProcessingRegistryReader() {
    }

    public static synchronized PostProcessingRegistryReader getInstance() {
        if (myInstance == null) {
            myInstance = new PostProcessingRegistryReader();
        }
        return myInstance;
    }

    public synchronized List<PostProcessingDescriptor> getExtensionProviders() {
        if (this.extensionProviders == null) {
            this.extensionProviders = new ArrayList<PostProcessingDescriptor>();
            this.retrieveExtensionProviders();
        }
        return this.extensionProviders;
    }

    private void retrieveExtensionProviders() {
        try {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(NAMESPACE_POST_PROCESSING_EXTENSION_POINT);
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension ext = extensions[i];
                    IConfigurationElement[] configElements = ext.getConfigurationElements();
                    int c = 0;
                    while (c < configElements.length) {
                        String id = configElements[c].getAttribute(NAMESPACE_POST_PROCESSING_ID);
                        String modelType = configElements[c].getAttribute(NAMESPACE_POST_PROCESSING_MODEL_TYPE);
                        IPostprocessProvider provider = (IPostprocessProvider)configElements[c].createExecutableExtension(NAMESPACE_POST_PROCESSING_CLASS);
                        PostProcessingDescriptor descriptor = new PostProcessingDescriptor(id, modelType, provider);
                        this.extensionProviders.add(descriptor);
                        ++c;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public IPostprocessProvider getPostProcessingExecutable() {
        IPostprocessProvider exe = null;
        List<PostProcessingDescriptor> extensionProviders = this.getExtensionProviders();
        if (extensionProviders != null) {
            for (PostProcessingDescriptor desc : extensionProviders) {
                if (!NAMESPACE_POST_PROCESSING_LDM.equalsIgnoreCase(desc.getModelType())) continue;
                exe = desc.getProvider();
                break;
            }
        }
        return exe;
    }
}

