/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.Subgraph;

class GraphUtilities {
    GraphUtilities() {
    }

    /*
     * WARNING - void declaration
     */
    static Subgraph getCommonAncestor(Node left, Node right) {
        Subgraph parent;
        Node node = right;
        if (node instanceof Subgraph) {
            void s;
            Subgraph subgraph = (Subgraph)node;
            Subgraph cfr_ignored_0 = (Subgraph)node;
            parent = s;
        } else {
            parent = right.getParent();
        }
        while (parent != null) {
            if (parent.isNested(left)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static boolean isCyclic(DirectedGraph graph) {
        return GraphUtilities.isCyclic(new NodeList(graph.nodes));
    }

    public static boolean isCyclic(NodeList nodes) {
        if (nodes.isEmpty()) {
            return false;
        }
        int size = nodes.size();
        for (Node node : nodes) {
            if (node.outgoing != null && !node.outgoing.isEmpty()) continue;
            nodes.remove(node);
            node.incoming.forEach(e -> {
                boolean bl = e.source.outgoing.remove(e);
            });
        }
        if (nodes.size() == size) {
            return true;
        }
        return GraphUtilities.isCyclic(nodes);
    }

    public static int numberOfCrossingsInGraph(DirectedGraph graph) {
        int crossings = 0;
        for (Rank rank : graph.ranks) {
            crossings += GraphUtilities.numberOfCrossingsInRank(rank);
        }
        return crossings;
    }

    public static int numberOfCrossingsInRank(Rank rank) {
        int crossings = 0;
        int i = 0;
        while (i < rank.size() - 1) {
            Node currentNode = (Node)rank.get(i);
            int j = i + 1;
            while (j < rank.size()) {
                Node nextNode = (Node)rank.get(j);
                for (Edge currentEdge : currentNode.outgoing) {
                    for (Edge nextEdge : nextNode.outgoing) {
                        if (nextEdge.getIndexForRank(currentNode.rank + 1) >= currentEdge.getIndexForRank(currentNode.rank + 1)) continue;
                        ++crossings;
                    }
                }
                ++j;
            }
            ++i;
        }
        return crossings;
    }

    private static NodeList search(Node node, NodeList list) {
        if (node.flag) {
            return list;
        }
        node.flag = true;
        list.add(node);
        node.outgoing.forEach(e -> {
            NodeList nodeList2 = GraphUtilities.search(e.target, list);
        });
        return list;
    }

    public static boolean willCauseCycle(Node source, Node target) {
        NodeList nodes = GraphUtilities.search(target, new NodeList());
        nodes.resetFlags();
        return nodes.contains(source);
    }

    static boolean isConstrained(Node left, Node right) {
        Subgraph common = left.getParent();
        while (common != null && !common.isNested(right)) {
            left = left.getParent();
            common = left.getParent();
        }
        while (right.getParent() != common) {
            right = right.getParent();
        }
        return left.getRowConstraint() != -1 && right.getRowConstraint() != -1 && left.getRowConstraint() != right.getRowConstraint();
    }
}

