/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.integration.wtp.ui.internal.dialogs;

import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FolderSelectionGroup {
    protected Label label;
    protected Text text;
    protected Button button;
    protected DirectoryDialog dialog;
    private String labelText = "Default Label";
    private String textValue = "";
    private String buttonText = "Select...";
    private String dialogTitle = "Browse For Folder";
    private String dialogMessage = "Please select the folder:";
    private String dialogFilterPath = "";
    private static final String DELIMITER = File.pathSeparator;

    public FolderSelectionGroup() {
    }

    public FolderSelectionGroup(String labelText, String buttonText, String dialogTitle, String dialogMessage, String dialogFilterPath) {
        this.labelText = labelText;
        this.buttonText = buttonText;
        this.dialogTitle = dialogTitle;
        this.dialogMessage = dialogMessage;
        this.dialogFilterPath = dialogFilterPath;
    }

    public void create(Composite parent) {
        Font font = parent.getFont();
        Label label = new Label(parent, 16384);
        label.setFont(font);
        label.setText(this.labelText);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        this.text = new Text(composite, 2048);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setFont(font);
        this.text.setText(this.textValue);
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.indexOf(DELIMITER) < 0;
            }
        });
        this.button = new Button(composite, 8);
        this.button.setFont(font);
        this.button.setText(this.buttonText);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FolderSelectionGroup.this.dialog = new DirectoryDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                FolderSelectionGroup.this.dialog.setText(FolderSelectionGroup.this.dialogTitle);
                FolderSelectionGroup.this.dialog.setMessage(FolderSelectionGroup.this.dialogMessage);
                FolderSelectionGroup.this.dialog.setFilterPath(FolderSelectionGroup.this.dialogFilterPath);
                String folderName = FolderSelectionGroup.this.dialog.open();
                if (folderName == null) {
                    return;
                }
                FolderSelectionGroup.this.text.setText(folderName);
            }
        });
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public String getDialogFilterPath() {
        return this.dialogFilterPath;
    }

    public void setDialogFilterPath(String dialogFilterPath) {
        this.dialogFilterPath = dialogFilterPath;
    }

    public String getDialogMessage() {
        return this.dialogMessage;
    }

    public void setDialogMessage(String dialogMessage) {
        this.dialogMessage = dialogMessage;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public Button getButton() {
        return this.button;
    }

    public DirectoryDialog getDialog() {
        return this.dialog;
    }

    public Label getLabel() {
        return this.label;
    }

    public Text getText() {
        return this.text;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }
}

