/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SortMap
implements Map {
    private List keyList = new ArrayList();
    private List entryList = new ArrayList();

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        int i = 0;
        while (i < this.keyList.size()) {
            if (this.keyList.get(i).equals(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        int i = 0;
        while (i < this.entryList.size()) {
            if (((Entry)this.entryList.get((int)i)).value.equals(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getIndexOf(Object key) {
        if (key == null) {
            return -1;
        }
        int i = 0;
        while (i < this.keyList.size()) {
            if (this.keyList.get(i).equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object putAt(Object key, Object value, int index) {
        if (key == null || value == null || index < 0 || index > this.keyList.size() + 1) {
            return null;
        }
        Object result = null;
        if (this.containsKey(key)) {
            result = this.get(key);
            this.remove(key);
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.value = value;
        this.entryList.add(entry);
        this.keyList.add(index, key);
        return result;
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            return null;
        }
        if (this.containsKey(key)) {
            Object result = this.get(key);
            int i = 0;
            while (i < this.entryList.size()) {
                if (((Entry)this.entryList.get((int)i)).key.equals(key)) {
                    ((Entry)this.entryList.get((int)i)).value = value;
                    break;
                }
                ++i;
            }
            return result;
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.value = value;
        this.entryList.add(entry);
        this.keyList.add(key);
        return null;
    }

    public Object remove(Object key) {
        if (key == null || !this.containsKey(key)) {
            return null;
        }
        Object result = null;
        int i = 0;
        while (i < this.entryList.size()) {
            if (((Entry)this.entryList.get((int)i)).key.equals(key)) {
                result = this.entryList.get(i);
                this.entryList.remove(i);
                break;
            }
            ++i;
        }
        this.keyList.remove(key);
        return result;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.keyList.size()) {
            return;
        }
        Object key = this.keyList.get(index);
        int i = 0;
        while (i < this.entryList.size()) {
            if (((Entry)this.entryList.get((int)i)).key.equals(key)) {
                this.entryList.remove(i);
                break;
            }
            ++i;
        }
        this.keyList.remove(key);
    }

    public List getKeyList() {
        return this.keyList;
    }

    public List getValueList() {
        LinkedList<Object> valueList = new LinkedList<Object>();
        int i = 0;
        while (i < this.keyList.size()) {
            valueList.add(this.get(this.keyList.get(i)));
            ++i;
        }
        return valueList;
    }

    public Object get(Object key) {
        if (key == null || !this.containsKey(key)) {
            return null;
        }
        int i = 0;
        while (i < this.entryList.size()) {
            if (((Entry)this.entryList.get((int)i)).key.equals(key)) {
                return ((Entry)this.entryList.get((int)i)).value;
            }
            ++i;
        }
        return null;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.keyList.size()) {
            return null;
        }
        Object key = this.keyList.get(index);
        int i = 0;
        while (i < this.entryList.size()) {
            if (((Entry)this.entryList.get((int)i)).key.equals(key)) {
                return ((Entry)this.entryList.get((int)i)).value;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void clear() {
        this.keyList.clear();
        this.entryList.clear();
    }

    @Override
    public int size() {
        return this.keyList.size();
    }

    public Set entrySet() {
        LinkedHashSet set = new LinkedHashSet(this.entryList);
        return set;
    }

    @Override
    public boolean isEmpty() {
        return this.keyList.isEmpty();
    }

    public Set keySet() {
        LinkedHashSet set = new LinkedHashSet(this.keyList);
        return set;
    }

    public void putAll(Map map) {
        Object[] keys = map.keySet().toArray();
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                this.put(keys[i], map.get(keys[i]));
                ++i;
            }
        }
    }

    public Collection values() {
        return this.getValueList();
    }

    private static class Entry
    implements Map.Entry {
        Object key;
        Object value;

        private Entry() {
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }
}

