/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveView;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;

public class RunTaskTest
extends EngineCase {
    static final String TEST_FOLDER = "./utest/";
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/run_task_design.xml";
    static final String BLANK_REPORT_DOCUMENT_RESOURCE = "org/eclipse/birt/report/engine/api/BlankReport.rptdocument";
    static final String BLANK_REPORT_DOCUMENT = "./utest/BlankReport.rptdocument";
    static final String VIEW_DOCUMENT = "./utest/view.rptdocument";
    static final String REPORT_DESIGN = "./utest/design.rptdesign";
    static final String REPORT_DOCUMENT = "./utest/reportdocument/";
    static final String REPORT_DOCUMENT_ZIP = "./utest/reportdocument.zip";
    static final String REPORT_DESIGN_RESOURCE1 = "org/eclipse/birt/report/engine/api/render_task_design.xml";
    static final String REPORT_DESIGN1 = "./utest/design.rptdesign";
    static final String REPORT_DOCUMENT1 = "./utest/reportdocument.folder/";

    public void setUp() throws Exception {
        super.setUp();
        this.removeFile(TEST_FOLDER);
        this.removeFile(REPORT_DOCUMENT_ZIP);
        this.copyResource(REPORT_DESIGN_RESOURCE, "./utest/design.rptdesign");
        this.copyResource(BLANK_REPORT_DOCUMENT_RESOURCE, BLANK_REPORT_DOCUMENT);
    }

    public void tearDown() throws Exception {
        this.removeFile(TEST_FOLDER);
        super.tearDown();
    }

    public void testRun() {
        try {
            IReportRunnable report = this.engine.openReportDesign("./utest/design.rptdesign");
            IRunTask task = this.engine.createRunTask(report);
            task.run(REPORT_DOCUMENT);
            task.close();
            IReportDocument doc = this.engine.openReportDocument(REPORT_DOCUMENT);
            doc.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RunTaskTest.fail();
        }
    }

    public void testRunWithArchiveView() {
        try {
            ArchiveView view = new ArchiveView(VIEW_DOCUMENT, BLANK_REPORT_DOCUMENT, "rw");
            ArchiveWriter writer = new ArchiveWriter((IArchiveFile)view);
            IReportRunnable report = this.engine.openReportDesign("./utest/design.rptdesign");
            IRunTask task = this.engine.createRunTask(report);
            task.run((IDocArchiveWriter)writer);
            task.close();
            writer.finish();
            view.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RunTaskTest.fail();
        }
    }
}

