/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.template;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.birt.core.template.TemplateParser;
import org.eclipse.birt.core.template.TextTemplate;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.template.TemplateExecutor;

public class TemplateExecutorTest
extends TestCase {
    public void testExecutor() {
        String input = "<value-of>textData</value-of> DEF <image type=''>imageData</image>";
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("textData", "RESULT");
        values.put("imageData", new byte[0]);
        String output = this.execute(input, values);
        boolean matched = output.matches("RESULT DEF <img src=.*>");
        TemplateExecutorTest.assertTrue((boolean)matched);
    }

    public void testFormat() {
        String input = "<value-of format=\"0.00\">textData</value-of>";
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("textData", 78.9711);
        String output = this.execute(input, values);
        TemplateExecutorTest.assertEquals((String)"78.97", (String)output);
    }

    public void testFormatExpression() {
        String input = "<value-of format-expr=format>textData</value-of>";
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("textData", 78.9711);
        values.put("format", "0.00");
        String output = this.execute(input, values);
        TemplateExecutorTest.assertEquals((String)"78.97", (String)output);
    }

    public void testExpressionWithWhitespace() {
        String input = "<value-of format-expr=\" format \"> textData </value-of>";
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("textData", 78.9711);
        values.put("format", "0.00");
        String output = this.execute(input, values);
        TemplateExecutorTest.assertEquals((String)"78.97", (String)output);
    }

    private String execute(String text, HashMap<String, Object> values) {
        TextTemplate template = new TemplateParser().parse(text);
        ExecutionContext context = new ExecutionContext();
        TemplateExecutor executor = new TemplateExecutor(context);
        return executor.execute(template, values);
    }
}

