/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLGroupLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLeafItemLM;
import org.eclipse.birt.report.engine.layout.html.HTMLListLM;
import org.eclipse.birt.report.engine.layout.html.HTMLListingBandLM;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.html.HTMLRowLM;
import org.eclipse.birt.report.engine.layout.html.HTMLTableBandLM;
import org.eclipse.birt.report.engine.layout.html.HTMLTableLM;
import org.eclipse.birt.report.engine.util.FastPool;

public class HTMLLayoutManagerFactory {
    private HTMLReportLayoutEngine engine;
    FastPool freeLeaf = new FastPool();
    FastPool freeBlock = new FastPool();
    FastPool freeTable = new FastPool();
    FastPool freeTableBand = new FastPool();
    FastPool freeRow = new FastPool();
    FastPool freeList = new FastPool();
    FastPool freeGroup = new FastPool();
    FastPool freeListBand = new FastPool();

    public HTMLLayoutManagerFactory(HTMLReportLayoutEngine engine) {
        this.engine = engine;
    }

    public HTMLReportLayoutEngine getLayoutEngine() {
        return this.engine;
    }

    public HTMLAbstractLM createLayoutManager(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) throws BirtException {
        HTMLAbstractLM layout = this.getLayoutManager(content);
        layout.initialize(parent, content, executor, emitter);
        return layout;
    }

    public void releaseLayoutManager(HTMLAbstractLM manager) {
        switch (manager.getType()) {
            case 0: {
                this.freeLeaf.add(manager);
                break;
            }
            case 1: {
                this.freeBlock.add(manager);
                break;
            }
            case 3: {
                this.freeTable.add(manager);
                break;
            }
            case 4: {
                this.freeTableBand.add(manager);
                break;
            }
            case 5: {
                this.freeRow.add(manager);
                break;
            }
            case 6: {
                this.freeList.add(manager);
                break;
            }
            case 8: {
                this.freeGroup.add(manager);
                break;
            }
            case 7: {
                this.freeListBand.add(manager);
            }
        }
    }

    private HTMLAbstractLM getLayoutManager(IContent content) throws BirtException {
        int type = content.getContentType();
        switch (type) {
            case -1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                return this.createLeafLM();
            }
            case 1: 
            case 2: {
                return this.createContainerLM();
            }
            case 15: 
            case 16: 
            case 17: {
                return this.createGroupLM();
            }
            case 14: {
                return this.createListBandLM();
            }
            case 13: {
                return this.createListLM();
            }
            case 8: {
                return this.createRowLM();
            }
            case 9: {
                return this.createTableBandLM();
            }
            case 10: {
                return this.createTableLM();
            }
        }
        throw new IllegalStateException();
    }

    private HTMLLeafItemLM createLeafLM() {
        if (!this.freeLeaf.isEmpty()) {
            return (HTMLLeafItemLM)this.freeLeaf.remove();
        }
        return new HTMLLeafItemLM(this);
    }

    private HTMLAbstractLM createContainerLM() {
        if (!this.freeBlock.isEmpty()) {
            return (HTMLBlockStackingLM)this.freeBlock.remove();
        }
        return new HTMLBlockStackingLM(this);
    }

    private HTMLAbstractLM createTableLM() {
        if (!this.freeTable.isEmpty()) {
            return (HTMLTableLM)this.freeTable.remove();
        }
        return new HTMLTableLM(this);
    }

    private HTMLAbstractLM createGroupLM() {
        if (!this.freeGroup.isEmpty()) {
            return (HTMLGroupLM)this.freeGroup.remove();
        }
        return new HTMLGroupLM(this);
    }

    private HTMLAbstractLM createTableBandLM() {
        if (!this.freeTableBand.isEmpty()) {
            return (HTMLTableBandLM)this.freeTableBand.remove();
        }
        return new HTMLTableBandLM(this);
    }

    private HTMLAbstractLM createRowLM() {
        if (!this.freeRow.isEmpty()) {
            return (HTMLRowLM)this.freeRow.remove();
        }
        return new HTMLRowLM(this);
    }

    private HTMLAbstractLM createListLM() {
        if (!this.freeList.isEmpty()) {
            return (HTMLListLM)this.freeList.remove();
        }
        return new HTMLListLM(this);
    }

    private HTMLAbstractLM createListBandLM() {
        if (!this.freeListBand.isEmpty()) {
            return (HTMLListingBandLM)this.freeListBand.remove();
        }
        return new HTMLListingBandLM(this);
    }
}

