/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.providers.IBreadcrumbNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.ReportFigureUtilities;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractTableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportContainerEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportElementNonResizablePolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.TableFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.AbstractGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.TableGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutCell;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutOwner;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayout;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabCellEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabGraphicsFactory;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.VirtualCellEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editpolicies.CrosstabXYLayoutEditPolicy;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabHandleAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.VirtualCrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.views.provider.CrosstabBreadcrumbNodeProvider;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.GuideLayer;

public class CrosstabTableEditPart
extends AbstractTableEditPart
implements PropertyChangeListener {
    public static final String CELL_HANDLE_LAYER = "Cell handles layer";
    private static final String GUIDEHANDLE_TEXT = Messages.getString("CrosstabTableEditPart.GuideText");
    protected static final String AGGREGATE_ON_ROW = "Aggregate On Row";
    protected static final String AGGREGATE_ON_COLUMN = "Aggregate On Column";
    private static final double LEFT = 30.0;
    private static final double RIGHT = 70.0;
    private static final int DEFAULT_HEIGHT = 23;
    private static final int BIG_DEFAULT_HEIGHT = 85;
    private static final int BIG_FIX_DEFAULT_HEIGHT = 45;
    CrosstabHandleAdapter adapter;
    private boolean isReload = false;

    public CrosstabTableEditPart() {
        super(null);
    }

    public CrosstabTableEditPart(Object model) {
        super(model);
    }

    public void activate() {
        this.getViewer().addPropertyChangeListener((PropertyChangeListener)this);
        super.activate();
    }

    public void deactivate() {
        this.getViewer().removePropertyChangeListener((PropertyChangeListener)this);
        super.deactivate();
    }

    public void setModel(Object model) {
        super.setModel(model);
        if (model != null) {
            try {
                this.adapter = new CrosstabHandleAdapter((CrosstabReportItemHandle)((ExtendedItemHandle)model).getReportItem());
            }
            catch (ExtendedElementException e) {
                throw new RuntimeException("load extended item error");
            }
        }
    }

    protected AbstractGuideHandle createGuideHandle() {
        TableGuideHandle handle = new TableGuideHandle((GraphicalEditPart)this);
        handle.setIndicatorLabel(this.getGuideLabel());
        INodeProvider provider = ProviderFactory.createProvider((Object)this.getModel());
        handle.setIndicatorIcon(provider.getNodeIcon(this.getModel()));
        handle.setToolTip((IFigure)ReportFigureUtilities.createToolTipFigure((String)provider.getNodeTooltip(this.getModel()), (String)"ltr", (String)"left"));
        return handle;
    }

    public String getGuideLabel() {
        return GUIDEHANDLE_TEXT;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy(){

            public boolean understandsRequest(Request request) {
                if ("direct edit".equals(request.getType()) || "open".equals(request.getType()) || "create element".equals(request.getType())) {
                    return true;
                }
                return super.understandsRequest(request);
            }
        });
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ReportContainerEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new CrosstabXYLayoutEditPolicy());
    }

    public void refreshFigure() {
        this.refreshBorder(this.getCrosstabHandleAdapter().getDesignElementHandle(), (BaseBorder)this.getFigure().getBorder());
        this.refreshBackground(this.getCrosstabHandleAdapter().getDesignElementHandle());
        this.refreshMargin();
        ((TableLayout)this.getContentPane().getLayoutManager()).markDirty();
    }

    protected IFigure createFigure() {
        TableFigure viewport = new TableFigure();
        viewport.setOpaque(false);
        this.innerLayers = new FreeformLayeredPane();
        this.createLayers((LayeredPane)this.innerLayers);
        viewport.setContents((IFigure)this.innerLayers);
        return viewport;
    }

    protected void createLayers(LayeredPane layeredPane) {
        FreeformLayer figure = new FreeformLayer();
        figure.setOpaque(false);
        layeredPane.add((IFigure)figure, (Object)CELL_HANDLE_LAYER);
        layeredPane.add((IFigure)this.getPrintableLayers(), (Object)"Printable Layers");
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Handle Layer");
        layeredPane.add((IFigure)new GuideLayer(), (Object)"Guide Layer");
    }

    protected LayeredPane getPrintableLayers() {
        if (this.printableLayers == null) {
            this.printableLayers = this.createPrintableLayers();
        }
        return this.printableLayers;
    }

    protected List getModelChildren() {
        List retValue = this.getCrosstabHandleAdapter().getModelList();
        return retValue;
    }

    public Rectangle getSelectBounds() {
        List list = TableUtil.getSelectionCells((ITableLayoutOwner)this);
        int size = list.size();
        ITableLayoutCell[] parts = new ITableLayoutCell[size];
        list.toArray(parts);
        ITableLayoutCell[] caleNumber = this.getMinAndMaxNumber(parts);
        ITableLayoutCell minRow = caleNumber[0];
        ITableLayoutCell maxColumn = caleNumber[3];
        Rectangle min = ((CrosstabCellEditPart)minRow).getBounds().getCopy();
        Rectangle max = ((CrosstabCellEditPart)maxColumn).getBounds().getCopy();
        return min.union(max);
    }

    public ITableLayoutCell[] getMinAndMaxNumber(ITableLayoutCell[] parts) {
        if (parts == null || parts.length == 0) {
            return null;
        }
        int size = parts.length;
        ITableLayoutCell leftTopPart = parts[0];
        ITableLayoutCell leftBottomPart = parts[0];
        ITableLayoutCell rightBottomPart = parts[0];
        ITableLayoutCell rightTopPart = parts[0];
        int i = 1;
        while (i < size) {
            ITableLayoutCell part = parts[i];
            if (part != null) {
                if (part.getRowNumber() <= leftTopPart.getRowNumber() && part.getColumnNumber() <= leftTopPart.getColumnNumber()) {
                    leftTopPart = part;
                }
                if (part.getRowNumber() <= rightTopPart.getRowNumber() && part.getColumnNumber() + part.getColSpan() - 1 >= leftTopPart.getColumnNumber()) {
                    rightTopPart = part;
                }
                if (part.getColumnNumber() <= leftBottomPart.getColumnNumber() && part.getRowNumber() + part.getRowSpan() - 1 >= leftBottomPart.getRowNumber()) {
                    leftBottomPart = part;
                }
                if (part.getRowNumber() + part.getRowSpan() - 1 >= rightBottomPart.getRowNumber() && part.getColumnNumber() + part.getColSpan() - 1 >= rightBottomPart.getColumnNumber()) {
                    rightBottomPart = part;
                }
            }
            ++i;
        }
        return new ITableLayoutCell[]{leftTopPart, rightTopPart, leftBottomPart, rightBottomPart};
    }

    public CrosstabHandleAdapter getCrosstabHandleAdapter() {
        return this.adapter;
    }

    public int getColumnCount() {
        return this.getCrosstabHandleAdapter().getColumnCount();
    }

    public ITableLayoutOwner.DimensionInfomation getColumnWidth(final int number) {
        DimensionHandle handle = this.getCrosstabHandleAdapter().getColumnWidth(number);
        if (handle == null) {
            if (number > 1 && this.getCrosstabHandleAdapter().getColumnWidth(number - 1) != null || number < this.getColumnCount() && this.getCrosstabHandleAdapter().getColumnWidth(number + 1) != null) {
                return new ITableLayoutOwner.DimensionInfomation(0.0, null);
            }
            return this.getVirtualDimension(new Conditional(){

                @Override
                public boolean evaluate(EditPart editpart) {
                    Object obj = editpart.getModel();
                    if (obj instanceof VirtualCrosstabCellAdapter) {
                        return number == ((VirtualCrosstabCellAdapter)obj).getColumnNumber();
                    }
                    return super.evaluate(editpart);
                }
            });
        }
        double value = handle.getMeasure();
        if ("%".equals(handle.getUnits())) {
            value = 0.0;
        }
        return new ITableLayoutOwner.DimensionInfomation(value, handle.getUnits(), handle.isSet());
    }

    private ITableLayoutOwner.DimensionInfomation getVirtualDimension(Conditional condion) {
        List parts = this.getChildren();
        int size = parts.size();
        int i = 0;
        while (i < size) {
            EditPart part = (EditPart)parts.get(i);
            if (condion.evaluate(part) && part.getModel() instanceof VirtualCrosstabCellAdapter) {
                int area = ((VirtualCrosstabCellAdapter)part.getModel()).getType();
                return this.getDimensionInfomation(area);
            }
            ++i;
        }
        return null;
    }

    private int getRowHeight(Conditional condion) {
        List parts = this.getChildren();
        int size = parts.size();
        int i = 0;
        while (i < size) {
            EditPart part = (EditPart)parts.get(i);
            if (condion.evaluate(part) && part.getModel() instanceof VirtualCrosstabCellAdapter) {
                int area = ((VirtualCrosstabCellAdapter)part.getModel()).getType();
                switch (area) {
                    case -1: 
                    case 1: {
                        return 23;
                    }
                    case 0: 
                    case 2: {
                        if (this.isFixLayout()) {
                            return 45;
                        }
                        return 85;
                    }
                }
                return 23;
            }
            ++i;
        }
        return 23;
    }

    private ITableLayoutOwner.DimensionInfomation getDimensionInfomation(int area) {
        switch (area) {
            case -1: 
            case 0: {
                return new ITableLayoutOwner.DimensionInfomation(30.0, "%");
            }
            case 1: 
            case 2: {
                return new ITableLayoutOwner.DimensionInfomation(70.0, "%");
            }
        }
        return null;
    }

    public int getColumnWidthValue(int number) {
        DimensionHandle handle = this.getCrosstabHandleAdapter().getColumnWidth(number);
        if (handle == null) {
            return this.getDefaultWidth(number);
        }
        if ("%".equals(handle.getUnits())) {
            ModuleHandle moduleHandle = this.getCrosstabHandleAdapter().getDesignElementHandle().getModuleHandle();
            if (moduleHandle instanceof ReportDesignHandle && "fixed layout".equals(((ReportDesignHandle)moduleHandle).getLayoutPreference())) {
                return this.getDefaultWidth(number);
            }
            Dimension dim = this.getFigure().getParent().getClientArea().getSize();
            int containerWidth = dim.width;
            return (int)(handle.getMeasure() * (double)containerWidth / 100.0);
        }
        int px = (int)DEUtil.convertoToPixel((Object)handle);
        if (this.isFixLayout() && handle.isSet() && px <= 0) {
            px = 1;
        }
        if (px <= 0) {
            return this.getDefaultWidth(number);
        }
        return px;
    }

    public Dimension getPreferredSize() {
        Dimension retValue = this.getFigure().getParent().getClientArea().getSize();
        Rectangle rect = this.getBounds();
        if (rect.width > 0) {
            retValue.width = rect.width;
        }
        if (rect.height > 0) {
            retValue.height = rect.height;
        }
        return retValue;
    }

    public int getDefaultWidth(int colNumber) {
        Dimension size = this.getPreferredSize().shrink(this.getFigure().getInsets().getWidth(), this.getFigure().getInsets().getHeight());
        if (this.getRowCount() == 0) {
            return size.width;
        }
        int allNumbers = this.getColumnCount();
        if (allNumbers <= 0 || colNumber <= 0) {
            return size.width;
        }
        int width = size.width;
        int columnNumber = allNumbers;
        int i = 1;
        while (i < columnNumber + 1) {
            ITableLayoutOwner.DimensionInfomation info;
            boolean bool;
            DimensionHandle dimHandle = this.getCrosstabHandleAdapter().getColumnWidth(colNumber);
            boolean bl = bool = this.isFixLayout() && dimHandle != null && "%".equals(dimHandle.getUnits());
            if (dimHandle != null && DEUtil.convertoToPixel((Object)dimHandle) > 1.0 && !bool) {
                --allNumbers;
                width -= this.getColumnWidthValue(colNumber);
            } else if (dimHandle == null && "%".equals((info = this.getColumnWidth(colNumber)).getUnits())) {
                Dimension dim = this.getFigure().getParent().getClientArea().getSize();
                int containerWidth = dim.width;
                width -= (int)(info.getMeasure() * (double)containerWidth / 100.0);
            }
            ++i;
        }
        if (colNumber == allNumbers) {
            return width / allNumbers + width % allNumbers;
        }
        return width / allNumbers;
    }

    public String getDefinedWidth() {
        return this.getCrosstabHandleAdapter().getDefinedWidth();
    }

    public boolean isForceWidth() {
        return false;
    }

    public String getRawWidth(int columNumber) {
        DimensionHandle handle = this.getCrosstabHandleAdapter().getColumnWidth(columNumber);
        if (handle == null) {
            ITableLayoutOwner.DimensionInfomation info = this.getColumnWidth(columNumber);
            if (info.getUnits() == null) {
                return "";
            }
            return String.valueOf(info.getMeasure()) + info.getUnits();
        }
        String unit = handle.getUnits();
        if (unit == null || unit.length() == 0) {
            return "";
        }
        if (unit.equals("%")) {
            return String.valueOf(handle.getMeasure()) + unit;
        }
        int px = (int)DEUtil.convertoToPixel((Object)handle);
        if (px <= 0) {
            return String.valueOf(this.getDefaultWidth(columNumber));
        }
        return String.valueOf(px);
    }

    public int getRowCount() {
        return this.getCrosstabHandleAdapter().getRowCount();
    }

    public ITableLayoutOwner.DimensionInfomation getRowHeight(final int number) {
        DimensionHandle handle = this.getCrosstabHandleAdapter().getRowHeight(number);
        if (handle == null) {
            return this.getVirtualDimension(new Conditional(){

                @Override
                public boolean evaluate(EditPart editpart) {
                    Object obj = editpart.getModel();
                    if (obj instanceof VirtualCrosstabCellAdapter) {
                        return number == ((VirtualCrosstabCellAdapter)obj).getRowNumber();
                    }
                    return super.evaluate(editpart);
                }
            });
        }
        return new ITableLayoutOwner.DimensionInfomation(handle.getMeasure(), handle.getUnits(), handle.isSet());
    }

    public int getRowHeightValue(final int number) {
        DimensionHandle handle = this.getCrosstabHandleAdapter().getRowHeight(number);
        if (handle == null) {
            return this.getRowHeight(new Conditional(){

                @Override
                public boolean evaluate(EditPart editpart) {
                    if (editpart instanceof VirtualCellEditPart && ((VirtualCellEditPart)editpart).getRowNumber() == number) {
                        return true;
                    }
                    return super.evaluate(editpart);
                }
            });
        }
        int px = (int)DEUtil.convertoToPixel((Object)handle);
        if (this.isFixLayout() && handle.isSet() && px <= 0) {
            px = 1;
        }
        if (px <= 0) {
            px = this.isFixLayout() ? 16 : 23;
        }
        return px;
    }

    private void layoutManagerLayout() {
        ((TableLayout)this.getContentPane().getLayoutManager()).markDirty();
    }

    public AbstractCellEditPart getCell(int rowNumber, int columnNumber) {
        List list = this.getChildren();
        int size = list.size();
        int i = 0;
        while (i < size) {
            AbstractCellEditPart part = (AbstractCellEditPart)list.get(i);
            if (rowNumber >= part.getRowNumber() && rowNumber < part.getRowNumber() + part.getRowSpan() && columnNumber >= part.getColumnNumber() && columnNumber < part.getColumnNumber() + part.getColSpan()) {
                return part;
            }
            ++i;
        }
        return null;
    }

    protected EditPart createChild(Object model) {
        EditPart part = CrosstabGraphicsFactory.INSTANCEOF.createEditPart((EditPart)this, model);
        if (part != null) {
            return part;
        }
        return super.createChild(model);
    }

    public void refreshChildren() {
        super.refreshChildren();
        List list = this.getChildren();
        int size = list.size();
        int i = 0;
        while (i < size) {
            ((ReportElementEditPart)list.get(i)).refreshChildren();
            ++i;
        }
        if (!this.adapter.layoutCheck()) {
            EditPart part = this.getParent();
            this.removeGuideFeedBack();
            ((ReportElementEditPart)part).removeChild((EditPart)this);
            part.refresh();
        }
    }

    public void notifyModelChange() {
        super.notifyModelChange();
        this.layoutManagerLayout();
    }

    public boolean isinterest(Object model) {
        if (!(model instanceof DesignElementHandle)) {
            return false;
        }
        DesignElementHandle handle = (DesignElementHandle)model;
        while (handle != null) {
            if (this.getModel().equals(handle)) {
                return true;
            }
            handle = handle.getContainer();
        }
        return super.isinterest(model);
    }

    public void refresh() {
        if (!this.isReload) {
            super.refresh();
            this.isReload = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("model event dipatch") && "start".equals(evt.getNewValue())) {
            this.isReload = false;
        }
    }

    protected void propertyChange(Map info) {
        Set set = info.keySet();
        for (Object obj : set) {
            if (!"measureDirection".equals(obj) && !"pageLayout".equals(obj) && !"aggregationHeaderLocation".equals(obj) && !"hideMeasureHeader".equals(obj) && !"grandTotalLocation".equals(obj) && !"header".equals(obj)) continue;
            this.refresh();
            return;
        }
        super.propertyChange(info);
    }

    public EditPolicy getResizePolice(EditPolicy parentPolice) {
        return new ReportElementNonResizablePolicy();
    }

    public String getDefinedHeight() {
        return null;
    }

    public Object getAdapter(Class key) {
        if (key == IBreadcrumbNodeProvider.class) {
            return new CrosstabBreadcrumbNodeProvider();
        }
        return super.getAdapter(key);
    }

    public boolean isinterestSelection(Object object) {
        if (Arrays.asList(ProviderFactory.createProvider((Object)this.getModel()).getChildren(this.getModel())).contains(object)) {
            return true;
        }
        return super.isinterestSelection(object);
    }

    public int getFixAllowMinRowHight() {
        return 18;
    }

    private static class Conditional {
        private Conditional() {
        }

        public boolean evaluate(EditPart editpart) {
            return false;
        }
    }
}

