/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.views.provider;

import java.util.logging.Level;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

public class CrossTabLevelNodeProvider
extends DefaultNodeProvider {
    public Object[] getChildren(Object model) {
        ExtendedItemHandle element = (ExtendedItemHandle)model;
        try {
            LevelViewHandle levelView = (LevelViewHandle)element.getReportItem();
            if (levelView != null) {
                if (levelView.getAggregationHeader() != null && levelView.getAggregationHeader().getModelHandle() != null) {
                    return new Object[]{levelView.getAggregationHeader().getModelHandle(), levelView.getCell().getModelHandle()};
                }
                return new Object[]{levelView.getCell().getModelHandle()};
            }
        }
        catch (ExtendedElementException extendedElementException) {
            // empty catch block
        }
        return new Object[0];
    }

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
    }

    public Object getParent(Object model) {
        ExtendedItemHandle element = (ExtendedItemHandle)model;
        try {
            DimensionViewHandle dimension;
            LevelViewHandle levelView = (LevelViewHandle)element.getReportItem();
            if (levelView.getContainer() != null && (dimension = (DimensionViewHandle)levelView.getContainer()).getContainer() != null) {
                return dimension.getContainer().getModelHandle();
            }
        }
        catch (ExtendedElementException extendedElementException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasChildren(Object model) {
        return this.getChildren(model).length != 0;
    }

    public String getNodeDisplayName(Object model) {
        ExtendedItemHandle element = (ExtendedItemHandle)model;
        try {
            LevelHandle level = ((LevelViewHandle)element.getReportItem()).getCubeLevel();
            String levelName = "";
            if (level != null) {
                levelName = level.getName();
            }
            return Messages.getString("CrossTabLevelNodeProvider.Level") + levelName;
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return super.getNodeDisplayName(model);
        }
    }

    public Image getNodeIcon(Object element) {
        if (element instanceof DesignElementHandle && ((DesignElementHandle)element).getSemanticErrors().size() > 0) {
            return ReportPlatformUIImages.getImage((String)"IMG_OBJS_ERROR_TSK");
        }
        return CrosstabUIHelper.getImage("icons/pal/level.gif");
    }
}

