/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineDecorator;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.GradientImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.NumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.component.DialRegion;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.DialRegionImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.DialChartImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.impl.DialSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class Regression_119411
extends ChartTestCase {
    private static String GOLDEN = "Reg_119411.jpg";
    private static String OUTPUT = "Reg_119411.jpg";
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new Regression_119411();
    }

    public Regression_119411() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_119411.createMeterChart();
        BufferedImage img = new BufferedImage(600, 600, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)600.0, (double)600.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public void test_regression_119411() throws Exception {
        Regression_119411 st = new Regression_119411();
        Regression_119411.assertTrue((boolean)st.compareImages(GOLDEN, OUTPUT));
    }

    public static final Chart createMeterChart() {
        DialChart dChart = (DialChart)DialChartImpl.create();
        dChart.setDialSuperimposition(false);
        dChart.setGridColumnCount(2);
        dChart.setSeriesThickness(25.0);
        dChart.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Plot p = dChart.getPlot();
        p.getClientArea().setBackground((Fill)ColorDefinitionImpl.CREAM());
        p.getClientArea().getOutline().setVisible(false);
        p.getOutline().setVisible(false);
        dChart.getTitle().getLabel().getCaption().setValue("Meter Chart");
        dChart.getTitle().getOutline().setVisible(false);
        Legend lg = dChart.getLegend();
        LineAttributes lia = lg.getOutline();
        lg.getText().getFont().setSize(16.0f);
        lia.setStyle(LineStyle.SOLID_LITERAL);
        lg.getInsets().setLeft(10.0);
        lg.getInsets().setRight(10.0);
        lg.setBackground(null);
        lg.getOutline().setVisible(false);
        lg.setShowValue(true);
        lg.getClientArea().setBackground((Fill)ColorDefinitionImpl.PINK());
        lg.getClientArea().getOutline().setVisible(true);
        lg.getTitle().getCaption().getFont().setSize(20.0f);
        lg.getTitle().setInsets(InsetsImpl.create((double)10.0, (double)10.0, (double)10.0, (double)10.0));
        lg.setTitlePosition(Position.ABOVE_LITERAL);
        lg.setPosition(Position.BELOW_LITERAL);
        lg.setItemType(LegendItemType.SERIES_LITERAL);
        TextDataSet categoryValues = TextDataSetImpl.create((Object)new String[]{"Moto"});
        SeriesDefinition sd = SeriesDefinitionImpl.create();
        dChart.getSeriesDefinitions().add((Object)sd);
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)categoryValues);
        sd.getSeries().add((Object)seCategory);
        SeriesDefinition sdCity = SeriesDefinitionImpl.create();
        Fill[] fiaOrth = new Fill[]{ColorDefinitionImpl.PINK(), ColorDefinitionImpl.ORANGE(), ColorDefinitionImpl.WHITE()};
        sdCity.getSeriesPalette().getEntries().clear();
        int i = 0;
        while (i < fiaOrth.length) {
            sdCity.getSeriesPalette().getEntries().add((Object)fiaOrth[i]);
            ++i;
        }
        DialSeries seDial1 = (DialSeries)DialSeriesImpl.create();
        seDial1.setDataSet((DataSet)NumberDataSetImpl.create((Object)new double[]{20.0}));
        NumberFormatSpecifier nb = NumberFormatSpecifierImpl.create();
        nb.setPrefix("abcdefga");
        seDial1.getDial().setFormatSpecifier((FormatSpecifier)nb);
        seDial1.getDial().setFill((Fill)GradientImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)225, (int)255, (int)225), (ColorDefinition)ColorDefinitionImpl.create((int)225, (int)225, (int)255), (double)45.0, (boolean)false));
        seDial1.setSeriesIdentifier((Object)"Temperature");
        seDial1.getNeedle().setDecorator(LineDecorator.CIRCLE_LITERAL);
        seDial1.getDial().setStartAngle(-45.0);
        seDial1.getDial().setStopAngle(225.0);
        seDial1.getDial().getMinorGrid().getTickAttributes().setVisible(true);
        seDial1.getDial().getMinorGrid().getTickAttributes().setColor(ColorDefinitionImpl.BLACK());
        seDial1.getDial().getMinorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        seDial1.getDial().getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        seDial1.getDial().getScale().setMax((DataElement)NumberDataElementImpl.create((double)90.0));
        seDial1.getDial().getScale().setStep(10.0);
        seDial1.getLabel().setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.GREY().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        seDial1.getLabel().setBackground((Fill)ColorDefinitionImpl.GREY().brighter());
        DialRegion dregion1 = DialRegionImpl.create();
        dregion1.setFill((Fill)ColorDefinitionImpl.GREEN());
        dregion1.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        dregion1.setStartValue((DataElement)NumberDataElementImpl.create((double)70.0));
        dregion1.setEndValue((DataElement)NumberDataElementImpl.create((double)90.0));
        dregion1.setInnerRadius(40.0);
        dregion1.setOuterRadius(-1.0);
        seDial1.getDial().getDialRegions().add((Object)dregion1);
        DialRegion dregion2 = DialRegionImpl.create();
        dregion2.setFill((Fill)ColorDefinitionImpl.YELLOW());
        dregion2.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        dregion2.setStartValue((DataElement)NumberDataElementImpl.create((double)40.0));
        dregion2.setEndValue((DataElement)NumberDataElementImpl.create((double)70.0));
        dregion2.setOuterRadius(70.0);
        seDial1.getDial().getDialRegions().add((Object)dregion2);
        DialRegion dregion3 = DialRegionImpl.create();
        dregion3.setFill((Fill)ColorDefinitionImpl.RED());
        dregion3.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        dregion3.setStartValue((DataElement)NumberDataElementImpl.create((double)0.0));
        dregion3.setEndValue((DataElement)NumberDataElementImpl.create((double)40.0));
        dregion3.setInnerRadius(40.0);
        dregion3.setOuterRadius(90.0);
        seDial1.getDial().getDialRegions().add((Object)dregion3);
        DialSeries seDial2 = (DialSeries)DialSeriesImpl.create();
        seDial2.setDataSet((DataSet)NumberDataSetImpl.create((Object)new double[]{58.0}));
        seDial2.getDial().setFill((Fill)GradientImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)225, (int)255, (int)225), (ColorDefinition)ColorDefinitionImpl.create((int)225, (int)225, (int)255), (double)45.0, (boolean)false));
        seDial2.setSeriesIdentifier((Object)"Wind Speed");
        seDial2.getNeedle().setDecorator(LineDecorator.CIRCLE_LITERAL);
        seDial2.getDial().setStartAngle(-45.0);
        seDial2.getDial().setStopAngle(225.0);
        seDial2.getDial().getMinorGrid().getTickAttributes().setVisible(true);
        seDial2.getDial().getMinorGrid().getTickAttributes().setColor(ColorDefinitionImpl.BLACK());
        seDial2.getDial().getMinorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        seDial2.getDial().getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        seDial2.getDial().getScale().setMax((DataElement)NumberDataElementImpl.create((double)90.0));
        seDial2.getDial().getScale().setStep(10.0);
        seDial2.getLabel().setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.GREY().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        seDial2.getLabel().setBackground((Fill)ColorDefinitionImpl.GREY().brighter());
        seDial2.getDial().getDialRegions().add((Object)dregion1);
        seDial2.getDial().getDialRegions().add((Object)dregion2);
        seDial2.getDial().getDialRegions().add((Object)dregion3);
        sd.getSeriesDefinitions().add((Object)sdCity);
        sdCity.getSeries().add((Object)seDial1);
        sdCity.getSeries().add((Object)seDial2);
        return dChart;
    }
}

