/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.internal.util.EclipseUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.utilities.IWebAppInfo;
import org.eclipse.birt.report.viewer.utilities.SocketUtil;
import org.eclipse.birt.report.viewer.utilities.ViewerWebApp;
import org.eclipse.birt.report.viewer.utilities.ViewerWebServer;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class AppServerWrapper {
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";
    private static AppServerWrapper wrapper = null;
    private String host = null;
    private Map<String, Integer> ports = new HashMap<String, Integer>();
    private ViewerWebServer viewerServer;
    private ViewerWebApp viewerApp;

    public static synchronized AppServerWrapper getInstance() {
        if (wrapper == null) {
            wrapper = new AppServerWrapper();
        }
        return wrapper;
    }

    private void configureServer(String webappName) {
        this.host = ViewerPlugin.getDefault().getPluginPreferences().getString(HOST_KEY);
        int port = ViewerPlugin.getDefault().getPluginPreferences().getInt(PORT_KEY);
        try {
            String hostCommandLineOverride = System.getProperty("server_host");
            if (hostCommandLineOverride != null && hostCommandLineOverride.trim().length() > 0) {
                this.host = hostCommandLineOverride;
            }
        }
        catch (Exception hostCommandLineOverride) {
            // empty catch block
        }
        try {
            String portCommandLineOverride = System.getProperty("server_port");
            if (portCommandLineOverride != null && portCommandLineOverride.trim().length() > 0) {
                port = Integer.parseInt(portCommandLineOverride);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.host == null || this.host.trim().length() <= 0) {
            this.host = null;
        }
        if (port <= 0) {
            port = SocketUtil.findUnusedLocalPort();
        }
        this.ports.put(webappName, port);
        System.setProperty("FISCAL_YEAR_START_DATE", UIUtil.getFiscalYearStart());
    }

    @Deprecated
    public void start(String webappName) throws Exception {
        this.start(webappName, "org.eclipse.birt.report.viewer");
    }

    public void start(String webappName, String pluginID) throws Exception {
        this.configureServer(webappName);
        this.startJettyServer(webappName);
    }

    public void stop(String webappName) throws Exception {
        this.stopJettyServer(webappName);
    }

    private void ensureBundleStarted(String symbolicName) throws BundleException {
        Bundle bundle = EclipseUtil.getBundle((String)symbolicName);
        if (bundle != null && bundle.getState() == 4) {
            bundle.start(1);
        }
    }

    String getHost() {
        return this.host == null ? "127.0.0.1" : this.host;
    }

    int getPort(String webappName) {
        return this.ports.get(webappName);
    }

    private void startJettyServer(String webAppName) throws Exception {
        System.setProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.StdErrLog");
        System.setProperty("org.eclipse.jetty.LEVEL", "DEBUG");
        System.setProperty("org.eclipse.jetty.websocket.LEVEL", "DEBUG");
        this.viewerServer = new ViewerWebServer(this.getHost(), this.getPort(webAppName));
        this.viewerServer.start();
        IWebAppInfo webAppInfo = WebViewer.getCurrentWebApp();
        Bundle webAppBundle = EclipseUtil.getBundle((String)webAppInfo.getID());
        this.viewerApp = new ViewerWebApp(this.viewerServer.getServer(), webAppBundle, webAppInfo.getWebAppPath(), webAppInfo.getWebAppContextPath(), webAppInfo.getURIEncoding());
        this.viewerApp.start();
    }

    private void stopJettyServer(String webAppName) throws Exception {
        this.viewerApp.stop();
        this.viewerServer.stop();
    }
}

