/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Scanner;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.HelpUi;

public class HelpUiJs
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String JS_TEMPLATE_PROPERTY = "org.eclipse.help.webapp.experimental.ui.js";
    private static final String JS_TEMPLATE_DEFAULT = "org.eclipse.help.webapp/m/index.js";
    private static final String JS_TEMPLATE = HelpUiJs.loadJsTemplate();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter writer = response.getWriter();){
            writer.write(HelpUi.resolve(JS_TEMPLATE, request));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String loadJsTemplate() {
        String customJsTemplate = System.getProperty(JS_TEMPLATE_PROPERTY);
        String jsTemplateLocation = customJsTemplate == null ? JS_TEMPLATE_DEFAULT : customJsTemplate;
        try {
            return HelpUiJs.loadTemplate(jsTemplateLocation);
        }
        catch (Exception e) {
            String msg = "Failed to load template file for 'index.js': " + jsTemplateLocation;
            ILog.of(HelpUiJs.class).error(msg, (Throwable)e);
            try {
                return HelpUiJs.loadTemplate(JS_TEMPLATE_DEFAULT);
            }
            catch (Exception e2) {
                String msg2 = "Failed to load default template file for 'index.js': org.eclipse.help.webapp/m/index.js";
                ILog.of(HelpUiJs.class).error(msg2, (Throwable)e2);
                return "";
            }
        }
    }

    private static String loadTemplate(String bundleLocation) throws IOException {
        String[] bundleAndPath = bundleLocation.split("/", 2);
        URL resourceAsUrl = Platform.getBundle((String)bundleAndPath[0]).getResource(bundleAndPath[1]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Scanner scanAll = new Scanner(resourceAsUrl.openStream()).useDelimiter("\\A");){
            String string = scanAll.hasNext() ? scanAll.next() : "";
            return string;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

