/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.util.StringMatcher;

public class TypeFilter
implements IEclipsePreferences.IPreferenceChangeListener {
    private StringMatcher[] fStringMatchers = null;

    public static TypeFilter getDefault() {
        return JavaManipulationPlugin.getDefault().getTypeFilter();
    }

    public static boolean isFiltered(String fullTypeName) {
        return TypeFilter.getDefault().filter(fullTypeName);
    }

    public static boolean isFiltered(char[] fullTypeName) {
        return TypeFilter.getDefault().filter(new String(fullTypeName));
    }

    public static boolean isFiltered(char[] packageName, char[] typeName) {
        return TypeFilter.getDefault().filter(JavaModelUtil.concatenateName(packageName, typeName));
    }

    public static boolean isFiltered(IType type) {
        TypeFilter typeFilter = TypeFilter.getDefault();
        if (typeFilter.hasFilters()) {
            return typeFilter.filter(type.getFullyQualifiedName('.'));
        }
        return false;
    }

    public static boolean isFiltered(TypeNameMatch match) {
        boolean filteredByPattern = TypeFilter.getDefault().filter(match.getFullyQualifiedName());
        if (filteredByPattern) {
            return true;
        }
        int accessibility = match.getAccessibility();
        switch (accessibility) {
            case 1: {
                return "enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.forbiddenReferenceCheck"));
            }
            case 2: {
                return "enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.discouragedReferenceCheck"));
            }
        }
        return false;
    }

    public synchronized void removeFilterIfMatched(Collection<String> importedElements) {
        if (importedElements == null || importedElements.isEmpty()) {
            return;
        }
        StringMatcher[] matchers = this.getStringMatchers();
        this.fStringMatchers = (StringMatcher[])Arrays.stream(matchers).filter((? super T m) -> {
            for (String importedElement : importedElements) {
                if (!m.match(importedElement)) continue;
                return false;
            }
            return true;
        }).toArray(StringMatcher[]::new);
    }

    public TypeFilter() {
        this.getPreferenceStore().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    private IEclipsePreferences getPreferenceStore() {
        return InstanceScope.INSTANCE.getNode(JavaManipulation.getPreferenceNodeId());
    }

    private IEclipsePreferences getDefaultPreferenceStore() {
        return DefaultScope.INSTANCE.getNode(JavaManipulation.getPreferenceNodeId());
    }

    private String getPreference(String key, String def) {
        String str = this.getPreferenceStore().get(key, null);
        if (str == null) {
            str = this.getDefaultPreferenceStore().get(key, null);
        }
        return str == null ? def : str;
    }

    private synchronized StringMatcher[] getStringMatchers() {
        if (this.fStringMatchers == null) {
            String str = this.getPreference("org.eclipse.jdt.ui.typefilter.enabled", "");
            StringTokenizer tok = new StringTokenizer(str, ";");
            int nTokens = tok.countTokens();
            this.fStringMatchers = new StringMatcher[nTokens];
            int i = 0;
            while (i < nTokens) {
                String curr = tok.nextToken();
                if (curr.length() > 0) {
                    this.fStringMatchers[i] = new StringMatcher(curr, false, false);
                }
                ++i;
            }
        }
        return this.fStringMatchers;
    }

    public void dispose() {
        this.getPreferenceStore().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.fStringMatchers = null;
    }

    public boolean hasFilters() {
        return this.getStringMatchers().length > 0;
    }

    public boolean filter(String fullTypeName) {
        StringMatcher[] stringMatcherArray = this.getStringMatchers();
        int n = stringMatcherArray.length;
        int n2 = 0;
        while (n2 < n) {
            StringMatcher curr = stringMatcherArray[n2];
            if (curr.match(fullTypeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("org.eclipse.jdt.ui.typefilter.enabled".equals(event.getKey())) {
            this.fStringMatchers = null;
        }
    }
}

