/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryLoadStrategyImpl;

public class ReadOnlyDirectoryLoadStrategyImpl
extends DirectoryLoadStrategyImpl {
    protected File subdirectory;

    public ReadOnlyDirectoryLoadStrategyImpl(String aDirectoryUri) {
        super(aDirectoryUri);
    }

    public ReadOnlyDirectoryLoadStrategyImpl(String rootDirectoryUri, File subdir) {
        super(rootDirectoryUri);
        this.setSubdirectory(subdir);
    }

    @Override
    protected void addDirectory(File aFile, List aList) {
        ReadOnlyDirectory dir = this.getArchiveFactory().createReadOnlyDirectory();
        dir.setLastModified(aFile.lastModified());
        dir.setURI(this.getURIFrom(aFile));
        dir.setLoadingContainer(this.getContainer());
        dir.setLoadStrategy(new ReadOnlyDirectoryLoadStrategyImpl(this.getDirectoryUri(), aFile));
        aList.add(dir);
    }

    @Override
    public boolean contains(String uri) {
        return super.contains(uri) && (this.getSubdirectory() == null || this.subdirectoryContains(uri));
    }

    @Override
    public String getAbsolutePath() throws FileNotFoundException {
        File subdir = this.getSubdirectory();
        if (subdir == null) {
            return super.getAbsolutePath();
        }
        return subdir.getAbsolutePath();
    }

    @Override
    protected File getDirectoryForList() {
        if (this.getSubdirectory() != null) {
            return this.getSubdirectory();
        }
        return new File(this.getDirectoryUri());
    }

    protected File getSubdirectory() {
        return this.subdirectory;
    }

    @Override
    protected boolean isArchive(String uri) {
        return false;
    }

    protected void setSubdirectory(File newSubdirectory) {
        this.subdirectory = newSubdirectory;
    }

    protected boolean subdirectoryContains(String uri) {
        if (this.getSubdirectory() == null) {
            return false;
        }
        File aFile = new File(this.getFileNameFrom(uri)).getParentFile();
        boolean contains = false;
        while (aFile != null && !contains) {
            if (this.getSubdirectory().equals(aFile)) {
                contains = true;
                continue;
            }
            aFile = aFile.getParentFile();
        }
        return contains;
    }
}

