/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.util;

import org.eclipse.birt.chart.device.util.ICharacterEncoderAdapter;

public class HTMLEncoderAdapter
implements ICharacterEncoderAdapter {
    private static HTMLEncoderAdapter instance;

    public static HTMLEncoderAdapter getInstance() {
        if (instance == null) {
            instance = new HTMLEncoderAdapter();
        }
        return instance;
    }

    @Override
    public String escape(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder result = null;
        char[] s2char = s.toCharArray();
        int i = 0;
        int max = s2char.length;
        int delta = 0;
        while (i < max) {
            char c = s2char[i];
            Object replacement = null;
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
                replacement = "";
            }
            if (c == '&') {
                replacement = "&amp;";
            } else if (c == '\"') {
                replacement = "&#34;";
            } else if (c == '\'') {
                replacement = "&#39;";
            } else if (c == '\r') {
                replacement = "&#13;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c >= '\u0080') {
                replacement = "&#x" + Integer.toHexString(c) + ";";
            }
            if (replacement != null) {
                if (result == null) {
                    result = new StringBuilder(s);
                }
                result.replace(i + delta, i + delta + 1, (String)replacement);
                delta += ((String)replacement).length() - 1;
            }
            ++i;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    @Override
    public String transformToJsConstants(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\"': {
                    buffer.append("\\\"");
                    break;
                }
                case '\'': {
                    buffer.append("\\'");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

