/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassLister {
    private static Logger logger = Logger.getLogger(ClassLister.class.getName());
    private static String ANONYMOUS_CLASS_REGEX = ".*\\Q$\\E[0-9]+.*";

    public static String[] listClasses(URL[] urls) {
        if (urls == null) {
            return new String[0];
        }
        HashSet<String> result = new HashSet<String>();
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                URL url = uRLArray[n2];
                File f = null;
                try {
                    f = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    logger.log(Level.WARNING, "Failed to transfer to file:" + String.valueOf(url), e);
                    break block7;
                }
                if (f.isFile()) {
                    result.addAll(ClassLister.listClassesFromJar(f));
                } else if (f.isDirectory()) {
                    result.addAll(ClassLister.listClassesFromDir(f, ""));
                }
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    private static Set<String> listClassesFromDir(File classFolder, String prefix) {
        HashSet<String> result = new HashSet<String>();
        File[] fileArray = classFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().endsWith(".class")) {
                Object className = prefix + f.getName().substring(0, f.getName().length() - 6);
                if ((className = ClassLister.process$((String)className)) != null) {
                    result.add((String)className);
                }
            } else if (f.isDirectory()) {
                String newPrefix = prefix + f.getName() + ".";
                result.addAll(ClassLister.listClassesFromDir(f, newPrefix));
            }
            ++n2;
        }
        return result;
    }

    private static Set<String> listClassesFromJar(File jarFile) {
        HashSet<String> result = new HashSet<String>();
        ArrayList<String> entries = new ArrayList<String>();
        try {
            ZipFile zf = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory()) continue;
                entries.add(ze.getName());
            }
            zf.close();
        }
        catch (IOException e1) {
            logger.log(Level.WARNING, "Failed to read file: " + String.valueOf(jarFile), e1);
        }
        for (String entry : entries) {
            if (!entry.endsWith(".class")) continue;
            String className = ClassLister.packagify(entry);
            if ((className = ClassLister.process$(className)) == null) continue;
            result.add(className);
        }
        return result;
    }

    private static String packagify(String resourceName) {
        resourceName = resourceName.replace('/', '.').substring(0, resourceName.length() - 6);
        return resourceName;
    }

    private static String process$(String className) {
        if (className.matches(ANONYMOUS_CLASS_REGEX)) {
            return null;
        }
        return className.replace('$', '.');
    }
}

