/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.command.SelectionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.views.actions.DeleteAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CutHandler
extends SelectionHandler {
    private static final String DEFAULT_TEXT = Messages.getString((String)"CutAction.text");

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        Object[] selection = this.getElementHandles().toArray();
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Cut action >> Cut " + Arrays.toString(selection));
        }
        Object cloneElements = DNDUtil.cloneSource((Object)selection);
        DeleteAction action = this.createDeleteAction(selection);
        action.run();
        if (action.hasExecuted()) {
            Clipboard.getDefault().setContents(cloneElements);
        }
        return Boolean.TRUE;
    }

    protected DeleteAction createDeleteAction(final Object objects) {
        return new DeleteAction(objects){

            @Override
            protected String getTransactionLabel() {
                if (objects instanceof IStructuredSelection) {
                    return Messages.getString((String)"CutAction.trans");
                }
                return DEFAULT_TEXT + " " + DEUtil.getDisplayLabel((Object)objects);
            }
        };
    }
}

