/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.ScriptDataSetRuntime;
import org.eclipse.birt.data.engine.script.JSRowObject;
import org.eclipse.birt.data.engine.script.JSStringMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class JSDataSetImpl {
    protected DataSetRuntime dataSet;

    public JSDataSetImpl(DataSetRuntime dataSet) {
        this.dataSet = dataSet;
    }

    public Scriptable getDataSource() throws DataException {
        IDataSourceInstanceHandle dataSource = this.dataSet.getDataSource();
        Scriptable ret = null;
        if (dataSource != null) {
            ret = dataSource.getScriptScope();
        }
        return ret;
    }

    public String getExtensionID() {
        return this.dataSet.getExtensionID();
    }

    public void setExtensionID(String id) {
    }

    public Scriptable getExtensionProperties() {
        Map<String, String> props = this.dataSet.getAllExtensionProperties();
        if (props != null) {
            return new JSStringMap(props);
        }
        return null;
    }

    public Map getAllExtensionProperties() {
        return this.dataSet.getAllExtensionProperties();
    }

    public String getExtensionProperty(String name) {
        return this.dataSet.getExtensionProperty(name);
    }

    public String getName() {
        return this.dataSet.getName();
    }

    public void setName(String name) {
    }

    public String getQueryText() throws BirtException {
        return this.dataSet.getQueryText();
    }

    public void setQueryText(String queryText) throws BirtException {
        this.dataSet.setQueryText(queryText);
    }

    public void setExtensionProperty(String name, String value) {
        this.dataSet.setExtensionProperty(name, value);
    }

    public Scriptable getRow() {
        return this.dataSet.getJSResultRowObject();
    }

    public Scriptable getDataSetRow() throws BirtException {
        return this.dataSet.getJSDataSetRowObject();
    }

    public Scriptable getRows() throws BirtException {
        return this.dataSet.getJSRowsObject();
    }

    public Scriptable getColumnDefns() throws BirtException {
        if (this.dataSet.getJSRowObject() != null) {
            return ((JSRowObject)this.dataSet.getJSRowObject()).getColumnMetadataScriptable();
        }
        return null;
    }

    public Scriptable getOutputParams() throws BirtException {
        return this.dataSet.getJSOutputParamsObject();
    }

    public Scriptable getInputParams() throws BirtException {
        return this.dataSet.getJSInputParamsObject();
    }

    public Scriptable get_aggr_value() {
        return this.dataSet.getJSAggrValueObject();
    }

    public Scriptable get_temp_aggr_value() {
        return this.dataSet.getJSTempAggrValueObject();
    }

    public void addDataSetColumn(String name, String type) {
        Class clazz;
        if (!(this.dataSet instanceof ScriptDataSetRuntime)) {
            return;
        }
        if ("INTEGER".equals(type)) {
            clazz = Integer.class;
        } else if ("DOUBLE".equals(type)) {
            clazz = Double.class;
        } else if ("DECIMAL".equals(type)) {
            clazz = BigDecimal.class;
        } else if ("DATE".equals(type)) {
            clazz = Date.class;
        } else if ("STRING".equals(type)) {
            clazz = String.class;
        } else if ("ANY".equals(type)) {
            clazz = DataType.AnyType.class;
        } else {
            throw Context.reportRuntimeError((String)("Invalid data type " + type));
        }
        try {
            ((ScriptDataSetRuntime)this.dataSet).addColumn(name, clazz);
        }
        catch (BirtException e) {
            throw Context.reportRuntimeError((String)e.getLocalizedMessage());
        }
    }
}

