/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class LibraryImageDescriptor
extends CompositeImageDescriptor {
    private ImageDescriptor fBaseImage;
    private ImageDescriptor fDecoratorImage;

    public LibraryImageDescriptor(Image baseImage, ImageDescriptor decoratorImage) {
        this.fBaseImage = new ImageImageDescriptor(baseImage);
        this.fDecoratorImage = decoratorImage;
    }

    public boolean equals(Object object) {
        if (object == null || !LibraryImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        LibraryImageDescriptor other = (LibraryImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.fBaseImage.getImageData();
        this.drawImage(bg, 0, 0);
        Point pos = new Point(this.getSize().y, this.getSize().y);
        ImageData data = this.fDecoratorImage.getImageData();
        this.addLeftBottomImage(data, pos);
    }

    protected Point getSize() {
        return new Point(this.fBaseImage.getImageData().width, this.fBaseImage.getImageData().height);
    }

    private void addLeftBottomImage(ImageData data, Point pos) {
        int y = pos.y - data.height;
        int x = pos.x - data.width;
        if (y >= 0 && x >= 0) {
            this.drawImage(data, x, y);
        }
    }

    private static class ImageImageDescriptor
    extends ImageDescriptor {
        private Image fImage;

        public ImageImageDescriptor(Image image) {
            this.fImage = image;
        }

        public ImageData getImageData() {
            return this.fImage.getImageData();
        }

        public boolean equals(Object obj) {
            return obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass()) && this.fImage.equals((Object)((ImageImageDescriptor)((Object)obj)).fImage);
        }

        public int hashCode() {
            return this.fImage.hashCode();
        }
    }
}

