/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jdt.junit.model.ITestSuiteElement;

public class TestSuiteElement
extends TestElement
implements ITestSuiteElement {
    private List<TestElement> fChildren;
    private TestElement.Status fChildrenStatus;

    public TestSuiteElement(TestSuiteElement parent, String id, String testName, int childrenCount, String displayName, String[] parameterTypes, String uniqueId) {
        super(parent, id, testName, displayName, parameterTypes, uniqueId);
        this.fChildren = new ArrayList<TestElement>(childrenCount);
    }

    @Override
    public ITestElement.Result getTestResult(boolean includeChildren) {
        TestCaseElement child = this.getSingleDynamicChild();
        if (child != null) {
            return child.getStatus().convertToResult();
        }
        if (includeChildren) {
            return this.getStatus().convertToResult();
        }
        return super.getStatus().convertToResult();
    }

    @Override
    public String getSuiteTypeName() {
        return this.getClassName();
    }

    @Override
    public ITestElement[] getChildren() {
        ITestElement[] elements = this.fChildren.toArray(new TestElement[this.fChildren.size()]);
        if (elements.length != 1 || !this.isSingleDynamicTest((TestElement)elements[0])) {
            return elements;
        }
        return new ITestElement[0];
    }

    public void addChild(TestElement child) {
        this.fChildren.add(child);
    }

    public void removeChild(TestElement child) {
        this.fChildren.remove(child);
    }

    @Override
    public TestElement.Status getStatus() {
        TestElement.Status suiteStatus = this.getSuiteStatus();
        if (this.fChildrenStatus != null) {
            return TestElement.Status.combineStatus(this.fChildrenStatus, suiteStatus);
        }
        return suiteStatus;
    }

    private TestElement.Status getCumulatedStatus() {
        TestElement[] children = this.fChildren.toArray(new TestElement[this.fChildren.size()]);
        if (children.length == 0) {
            return this.getSuiteStatus();
        }
        TestElement.Status cumulated = children[0].getStatus();
        int i = 1;
        while (i < children.length) {
            TestElement.Status childStatus = children[i].getStatus();
            cumulated = TestElement.Status.combineStatus(cumulated, childStatus);
            ++i;
        }
        return cumulated;
    }

    public TestElement.Status getSuiteStatus() {
        return super.getStatus();
    }

    public void childChangedStatus(TestElement child, TestElement.Status childStatus) {
        int childCount = this.fChildren.size();
        if (child == this.fChildren.get(0) && childStatus.isRunning()) {
            this.internalSetChildrenStatus(childStatus);
            return;
        }
        TestElement lastChild = this.fChildren.get(childCount - 1);
        if (child == lastChild) {
            if (childStatus.isDone()) {
                this.internalSetChildrenStatus(this.getCumulatedStatus());
                return;
            }
        } else if (!lastChild.getStatus().isNotRun()) {
            this.internalSetChildrenStatus(this.getCumulatedStatus());
            return;
        }
        if (childStatus.isFailure()) {
            if (this.fChildrenStatus == null || !this.fChildrenStatus.isErrorOrFailure()) {
                this.internalSetChildrenStatus(TestElement.Status.RUNNING_FAILURE);
                return;
            }
        } else if (childStatus.isError() && (this.fChildrenStatus == null || !this.fChildrenStatus.isError())) {
            this.internalSetChildrenStatus(TestElement.Status.RUNNING_ERROR);
            return;
        }
    }

    private void internalSetChildrenStatus(TestElement.Status status) {
        if (this.fChildrenStatus == status) {
            return;
        }
        if (status == TestElement.Status.RUNNING) {
            if (!(this.fTime >= 0.0)) {
                this.fTime = (double)(-System.currentTimeMillis()) / 1000.0;
            }
        } else if (status.convertToProgressState() == ITestElement.ProgressState.COMPLETED && this.fTime < 0.0) {
            double endTime = (double)System.currentTimeMillis() / 1000.0;
            this.fTime = endTime + this.fTime;
        }
        this.fChildrenStatus = status;
        TestSuiteElement parent = this.getParent();
        if (parent != null) {
            parent.childChangedStatus(this, this.getStatus());
        }
    }

    @Override
    public String toString() {
        return "TestSuite: " + this.getTestName() + " : " + super.toString() + " (" + this.fChildren.size() + ")";
    }

    private boolean isSingleDynamicTest(TestElement element) {
        TestCaseElement testCase;
        return element instanceof TestCaseElement && (testCase = (TestCaseElement)element).isDynamicTest() && this.fChildren.size() == 1;
    }

    public TestCaseElement getSingleDynamicChild() {
        try {
            TestElement child;
            if (this.fChildren.size() == 1 && this.isSingleDynamicTest(child = this.fChildren.get(0))) {
                return (TestCaseElement)child;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isComparisonFailure() {
        TestCaseElement child = this.getSingleDynamicChild();
        if (child == null) {
            return super.isComparisonFailure();
        }
        return child.isComparisonFailure();
    }

    @Override
    public boolean isAssumptionFailure() {
        TestCaseElement child = this.getSingleDynamicChild();
        if (child == null) {
            return super.isAssumptionFailure();
        }
        return child.isAssumptionFailure();
    }

    @Override
    public ITestElement.FailureTrace getFailureTrace() {
        TestCaseElement child = this.getSingleDynamicChild();
        if (child == null) {
            return super.getFailureTrace();
        }
        return child.getFailureTrace();
    }

    @Override
    public String getTrace() {
        TestCaseElement child = this.getSingleDynamicChild();
        if (child != null) {
            return child.getTrace();
        }
        return super.getTrace();
    }

    @Override
    public String getExpected() {
        TestCaseElement child = this.getSingleDynamicChild();
        if (child == null) {
            return super.getExpected();
        }
        return child.getExpected();
    }

    @Override
    public String getActual() {
        TestCaseElement child = this.getSingleDynamicChild();
        if (child == null) {
            return super.getActual();
        }
        return child.getActual();
    }
}

