/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.script.series;

import org.eclipse.birt.chart.script.api.component.IValueSeries;
import org.eclipse.birt.chart.script.api.series.IPie;
import org.eclipse.birt.chart.script.api.series.data.ISimpleData;
import org.eclipse.birt.chart.tests.script.BaseChartTestCase;

public class PieSeriesTest
extends BaseChartTestCase {
    public void testGetDataExpr() {
        IValueSeries series = this.getChartWithoutAxes().getValueSeries()[0];
        PieSeriesTest.assertTrue((boolean)(series instanceof IPie));
        PieSeriesTest.assertTrue((boolean)(series.getDataExpr() instanceof ISimpleData));
        PieSeriesTest.assertEquals((String)((ISimpleData)series.getDataExpr()).getExpr(), (String)"row[\"ORDERNUMBER\"]");
    }

    public void testMinSlice() {
        IPie pie = (IPie)this.getChartWithoutAxes().getValueSeries()[0];
        PieSeriesTest.assertTrue((pie.getMinSlice() == 10000.0 ? 1 : 0) != 0);
        pie.setMinSlice(10001.0);
        PieSeriesTest.assertTrue((pie.getMinSlice() == 10001.0 ? 1 : 0) != 0);
    }

    public void testMinSliceLabel() {
        IPie pie = (IPie)this.getChartWithoutAxes().getValueSeries()[0];
        PieSeriesTest.assertEquals((String)pie.getMinSliceLabel(), (String)"Label");
        pie.setMinSliceLabel("");
        PieSeriesTest.assertEquals((String)pie.getMinSliceLabel(), (String)"");
    }

    public void testExplosionExpr() {
        IPie pie = (IPie)this.getChartWithoutAxes().getValueSeries()[0];
        PieSeriesTest.assertEquals((String)pie.getExplosionExpr(), (String)"valueData>10005");
        pie.setExplosionExpr("");
        PieSeriesTest.assertEquals((String)pie.getExplosionExpr(), (String)"");
    }
}

