/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;

public class ReportPageReaderTest
extends EngineCase {
    public void testHtmlPagination() throws EngineException, IOException {
        String designFile = "org/eclipse/birt/report/engine/internal/executor/doc/report-page-reader.xml";
        String result = this.getRenderResult(designFile, true, true);
        ReportPageReaderTest.assertEquals((int)2, (int)this.getOccurCount(result, "pageHeader"));
        ReportPageReaderTest.assertEquals((int)2, (int)this.getOccurCount(result, "pageFooter"));
        ReportPageReaderTest.assertEquals((int)2, (int)this.getOccurCount(result, "tableHeader"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "tableFooter"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "itemA"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "itemB"));
        result = this.getRenderResult(designFile, true, false);
        ReportPageReaderTest.assertEquals((int)0, (int)this.getOccurCount(result, "pageHeader"));
        ReportPageReaderTest.assertEquals((int)0, (int)this.getOccurCount(result, "pageFooter"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "<hr>"));
        ReportPageReaderTest.assertEquals((int)2, (int)this.getOccurCount(result, "tableHeader"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "tableFooter"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "itemA"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "itemB"));
        result = this.getRenderResult(designFile, false, true);
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "pageHeader"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "pageFooter"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "tableHeader"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "tableFooter"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "itemA"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "itemB"));
        result = this.getRenderResult(designFile, false, false);
        ReportPageReaderTest.assertEquals((int)0, (int)this.getOccurCount(result, "pageHeader"));
        ReportPageReaderTest.assertEquals((int)0, (int)this.getOccurCount(result, "pageFooter"));
        ReportPageReaderTest.assertEquals((int)0, (int)this.getOccurCount(result, "<hr>"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "tableHeader"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "tableFooter"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "itemA"));
        ReportPageReaderTest.assertEquals((int)1, (int)this.getOccurCount(result, "itemB"));
    }

    private int getOccurCount(String string, String subString) {
        if (subString == null) {
            return 0;
        }
        String container = string;
        String match = subString;
        int count = 0;
        int index = -1;
        while ((index = container.indexOf(match)) >= 0) {
            ++count;
            container = container.substring(index + subString.length());
        }
        return count;
    }

    private String getRenderResult(String designFile, boolean pagination, boolean showMasterPage) throws EngineException, IOException {
        HTMLRenderOption options = new HTMLRenderOption();
        options.setHtmlPagination(pagination);
        options.setMasterPageContent(showMasterPage);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        options.setOutputStream((OutputStream)out);
        this.render(designFile, (IRenderOption)options);
        String content = new String(out.toByteArray());
        out.close();
        return content;
    }
}

