/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.MemberForTest;
import org.junit.Assert;
import org.junit.Test;

public class BufferedStructureArrayTest {
    @Test
    public void testMemberForTest() throws IOException {
        int objectNumber = 1001;
        BufferedStructureArray list = new BufferedStructureArray(MemberForTest.getMemberCreator(), 200);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)BufferedStructureArrayTest.createMember(i));
            ++i;
        }
        Assert.assertEquals((long)list.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)list.get(i), (Object)BufferedStructureArrayTest.createMember(i));
            ++i;
        }
        list.close();
    }

    @Test
    public void testMemberForTest1() throws IOException {
        int objectNumber = 10001;
        BufferedStructureArray list = new BufferedStructureArray(MemberForTest.getMemberCreator(), 200);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)BufferedStructureArrayTest.createMember(i));
            try {
                list.get(i + 1);
                Assert.fail();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
        Assert.assertEquals((long)list.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)list.get(i), (Object)BufferedStructureArrayTest.createMember(i));
            ++i;
        }
        list.close();
    }

    @Test
    public void testMemberForTest2() throws IOException {
        int objectNumber1 = 5401;
        int objectNumber2 = 2000;
        BufferedStructureArray list = new BufferedStructureArray(MemberForTest.getMemberCreator(), 200);
        int i = 0;
        while (i < objectNumber1) {
            list.add((Object)BufferedStructureArrayTest.createMember(i));
            ++i;
        }
        Assert.assertEquals((long)list.size(), (long)objectNumber1);
        i = 0;
        while (i < objectNumber1) {
            Assert.assertEquals((Object)list.get(i), (Object)BufferedStructureArrayTest.createMember(i));
            ++i;
        }
        i = 0;
        while (i < objectNumber2) {
            list.add((Object)BufferedStructureArrayTest.createMember(i));
            ++i;
        }
        Assert.assertEquals((long)list.size(), (long)(objectNumber1 + objectNumber2));
        i = 0;
        while (i < objectNumber2) {
            Assert.assertEquals((Object)list.get(objectNumber1 + i), (Object)BufferedStructureArrayTest.createMember(i));
            ++i;
        }
        list.close();
    }

    @Test
    public void testMemberForTest3() throws IOException {
        int objectNumber = 10001;
        BufferedStructureArray list = new BufferedStructureArray(MemberForTest.getMemberCreator(), 200);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)BufferedStructureArrayTest.createMember(i));
            Assert.assertEquals((long)list.size(), (long)(i + 1));
            Assert.assertEquals((Object)list.get(i), (Object)BufferedStructureArrayTest.createMember(i));
            ++i;
        }
        list.close();
    }

    @Test
    public void testStress() throws IOException {
        long startTime = System.currentTimeMillis();
        int objectNumber = 100000;
        BufferedStructureArray list = new BufferedStructureArray(MemberForTest.getMemberCreator(), 200);
        int i = 0;
        while (i < objectNumber) {
            list.add((Object)BufferedStructureArrayTest.createMember(i));
            ++i;
        }
        System.out.println("used add:" + (System.currentTimeMillis() - startTime) / 100L);
        Assert.assertEquals((long)list.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)list.get(i), (Object)BufferedStructureArrayTest.createMember(i));
            ++i;
        }
        System.out.println("used get:" + (System.currentTimeMillis() - startTime) / 100L);
        list.close();
    }

    private static MemberForTest createMember(int i) {
        int iField = i;
        Date dateField = new Date(190001000 + i * 1000);
        String stringField = "string" + i;
        double doubleField = (double)i + 10.0;
        BigDecimal bigDecimalField = new BigDecimal("1010101010100101010110" + i);
        boolean booleanField = i % 2 == 0;
        return new MemberForTest(iField, dateField, stringField, doubleField, bigDecimalField, booleanField);
    }
}

