/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.integration.wtp.ui.project.facet;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.integration.wtp.ui.internal.util.DataUtil;
import org.eclipse.birt.integration.wtp.ui.internal.util.WebArtifactUtil;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ContextParamBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.FilterBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.FilterMappingBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ListenerBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ServletBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ServletMappingBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.TagLibBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.WebAppBean;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.IBirtWizardConstants;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.SimpleImportOverwriteQuery;
import org.eclipse.birt.integration.wtp.ui.project.facet.IBirtFacetUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.Listener;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.jsp.JSPConfig;
import org.eclipse.jst.j2ee.jsp.JspFactory;
import org.eclipse.jst.j2ee.jsp.TagLibRefType;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;

public class BirtFacetUtil
implements IBirtFacetUtil,
IBirtWizardConstants {
    @Override
    public void configureContextParam(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            ContextParam param;
            String name = DataUtil.getString(it.next(), false);
            ContextParamBean bean = (ContextParamBean)map.get(name);
            if (bean == null) continue;
            EList list = null;
            list = webApp.getVersionID() == 23 ? webApp.getContexts() : webApp.getContextParams();
            int index = this.getContextParamIndexByName((List)list, name);
            if (index >= 0) {
                String ret = query.queryOverwrite("Context-param '" + name + "'");
                if ("NO".equalsIgnoreCase(ret)) continue;
                if ("CANCEL".equalsIgnoreCase(ret)) {
                    monitor.setCanceled(true);
                    return;
                }
                list.remove(index);
            }
            String value = bean.getValue();
            String description = bean.getDescription();
            if (webApp.getVersionID() == 23) {
                param = WebapplicationFactory.eINSTANCE.createContextParam();
                param.setParamName(name);
                param.setParamValue(value);
                if (description != null) {
                    param.setDescription(description);
                }
                param.setWebApp(webApp);
                continue;
            }
            param = CommonFactory.eINSTANCE.createParamValue();
            param.setName(name);
            param.setValue(value);
            if (description != null) {
                Description descriptionObj = CommonFactory.eINSTANCE.createDescription();
                descriptionObj.setValue(description);
                param.getDescriptions().add((Object)descriptionObj);
                param.setDescription(description);
            }
            webApp.getContextParams().add((Object)param);
        }
    }

    private int getContextParamIndexByName(List list, String name) {
        if (list == null || name == null) {
            return -1;
        }
        Iterator it = list.iterator();
        int index = 0;
        while (it.hasNext()) {
            ContextParam param;
            Object paramObj = it.next();
            if (paramObj instanceof ContextParam && name.equals((param = (ContextParam)paramObj).getParamName())) {
                return index;
            }
            if (paramObj instanceof ParamValue && name.equals((param = (ParamValue)paramObj).getName())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void configureFilter(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String name = DataUtil.getString(it.next(), false);
            FilterBean bean = (FilterBean)map.get(name);
            if (bean == null) continue;
            Filter obj = webApp.getFilterNamed(name);
            if (obj != null) {
                String ret = query.queryOverwrite("Filter '" + name + "'");
                if ("NO".equalsIgnoreCase(ret)) continue;
                if ("CANCEL".equalsIgnoreCase(ret)) {
                    monitor.setCanceled(true);
                    return;
                }
                webApp.getFilters().remove((Object)obj);
            }
            String className = bean.getClassName();
            String description = bean.getDescription();
            Filter filter = WebapplicationFactory.eINSTANCE.createFilter();
            filter.setName(name);
            filter.setFilterClassName(className);
            filter.setDescription(description);
            webApp.getFilters().add((Object)filter);
        }
    }

    @Override
    public void configureFilterMapping(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = DataUtil.getString(it.next(), false);
            FilterMappingBean bean = (FilterMappingBean)map.get(key);
            if (bean == null) continue;
            Object obj = this.getFilterMappingByKey((List)webApp.getFilterMappings(), key);
            if (obj != null) {
                String ret = query.queryOverwrite("Filter-mapping '" + key + "'");
                if ("NO".equalsIgnoreCase(ret)) continue;
                if ("CANCEL".equalsIgnoreCase(ret)) {
                    monitor.setCanceled(true);
                    return;
                }
                webApp.getFilterMappings().remove(obj);
            }
            String name = bean.getName();
            FilterMapping mapping = WebapplicationFactory.eINSTANCE.createFilterMapping();
            Filter filter = webApp.getFilterNamed(name);
            if (filter == null) continue;
            mapping.setFilter(filter);
            mapping.setUrlPattern(bean.getUri());
            mapping.setServletName(bean.getServletName());
            Servlet servlet = webApp.getServletNamed(bean.getServletName());
            mapping.setServlet(servlet);
            if (bean.getUri() == null && servlet == null) continue;
            webApp.getFilterMappings().add((Object)mapping);
        }
    }

    private Object getFilterMappingByKey(List list, String key) {
        if (list == null || key == null) {
            return null;
        }
        for (FilterMapping filterMapping : list) {
            String uri;
            String servletName;
            String name;
            String curKey;
            if (filterMapping == null || !key.equals(curKey = this.getFilterMappingString(name = filterMapping.getFilter().getName(), servletName = filterMapping.getServletName(), uri = filterMapping.getUrlPattern()))) continue;
            return filterMapping;
        }
        return null;
    }

    private String getFilterMappingString(String name, String servletName, String uri) {
        return (name != null ? name : "") + (servletName != null ? servletName : "") + (uri != null ? uri : "");
    }

    @Override
    public void configureListener(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String name = DataUtil.getString(it.next(), false);
            ListenerBean bean = (ListenerBean)map.get(name);
            if (bean == null) continue;
            String className = bean.getClassName();
            String description = bean.getDescription();
            Object obj = this.getListenerByClassName((List)webApp.getListeners(), className);
            if (obj != null) continue;
            Listener listener = CommonFactory.eINSTANCE.createListener();
            listener.setListenerClassName(className);
            if (description != null) {
                listener.setDescription(description);
            }
            webApp.getListeners().remove((Object)listener);
            webApp.getListeners().add((Object)listener);
        }
    }

    private Object getListenerByClassName(List list, String className) {
        if (list == null || className == null) {
            return null;
        }
        for (Listener listener : list) {
            if (listener == null || !className.equals(listener.getListenerClassName())) continue;
            return listener;
        }
        return null;
    }

    @Override
    public void configureServlet(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String name = DataUtil.getString(it.next(), false);
            ServletBean bean = (ServletBean)map.get(name);
            if (bean == null) continue;
            Servlet obj = webApp.getServletNamed(name);
            if (obj != null) {
                String ret = query.queryOverwrite("Servlet '" + name + "'");
                if ("NO".equalsIgnoreCase(ret)) continue;
                if ("CANCEL".equalsIgnoreCase(ret)) {
                    monitor.setCanceled(true);
                    return;
                }
                webApp.getServlets().remove((Object)obj);
            }
            String className = bean.getClassName();
            String description = bean.getDescription();
            ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
            servletType.setClassName(className);
            Servlet servlet = WebapplicationFactory.eINSTANCE.createServlet();
            servlet.setServletName(name);
            if (description != null) {
                servlet.setDescription(description);
            }
            servlet.setWebType((WebType)servletType);
            servlet.setWebApp(webApp);
        }
    }

    private WebApp getWebApp(Map map, IProject project, IProgressMonitor monitor) {
        if (monitor.isCanceled() || map == null || project == null) {
            return null;
        }
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
        Object modelObject = modelProvider.getModelObject();
        if (!(modelObject instanceof WebApp)) {
            return null;
        }
        return (WebApp)modelObject;
    }

    @Override
    public void configureServletMapping(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String uri = DataUtil.getString(it.next(), false);
            ServletMappingBean bean = (ServletMappingBean)map.get(uri);
            if (bean == null) continue;
            Object obj = WebArtifactUtil.getServletMappingByUri((List)webApp.getServletMappings(), uri);
            if (obj != null) {
                String ret = query.queryOverwrite("Servlet-mapping '" + uri + "'");
                if ("NO".equalsIgnoreCase(ret)) continue;
                if ("CANCEL".equalsIgnoreCase(ret)) {
                    monitor.setCanceled(true);
                    return;
                }
                webApp.getServletMappings().remove(obj);
            }
            String name = bean.getName();
            ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
            Servlet servlet = webApp.getServletNamed(name);
            if (servlet == null) continue;
            mapping.setServlet(servlet);
            mapping.setUrlPattern(uri);
            mapping.setWebApp(webApp);
        }
    }

    @Override
    public void configureTaglib(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String uri = DataUtil.getString(it.next(), false);
            TagLibBean bean = (TagLibBean)map.get(uri);
            if (bean == null) continue;
            Object obj = this.getTagLibByUri(webApp, uri);
            if (obj != null) {
                String ret = query.queryOverwrite("Taglib '" + uri + "'");
                if ("NO".equalsIgnoreCase(ret)) continue;
                if ("CANCEL".equalsIgnoreCase(ret)) {
                    monitor.setCanceled(true);
                    return;
                }
                if (obj instanceof TagLibRefType && webApp.getJspConfig() != null) {
                    webApp.getJspConfig().getTagLibs().remove(obj);
                } else {
                    webApp.getTagLibs().remove(obj);
                }
            }
            String location = bean.getLocation();
            if (webApp.getVersionID() == 23) {
                TagLibRef taglib = WebapplicationFactory.eINSTANCE.createTagLibRef();
                taglib.setTaglibURI(uri);
                taglib.setTaglibLocation(location);
                webApp.getTagLibs().add((Object)taglib);
                continue;
            }
            JSPConfig jspConfig = JspFactory.eINSTANCE.createJSPConfig();
            TagLibRefType ref = JspFactory.eINSTANCE.createTagLibRefType();
            ref.setTaglibURI(uri);
            ref.setTaglibLocation(location);
            jspConfig.getTagLibs().add((Object)ref);
            webApp.setJspConfig(jspConfig);
        }
    }

    private Object getTagLibByUri(WebApp webapp, String uri) {
        if (webapp == null || uri == null) {
            return null;
        }
        EList list = null;
        JSPConfig config = webapp.getJspConfig();
        list = config != null ? config.getTagLibs() : webapp.getTagLibs();
        for (Object obj : list) {
            TagLibRef ref;
            if (obj instanceof TagLibRef && uri.equals((ref = (TagLibRef)obj).getTaglibURI())) {
                return ref;
            }
            if (!(obj instanceof TagLibRefType) || !uri.equals((ref = (TagLibRefType)obj).getTaglibURI())) continue;
            return ref;
        }
        return null;
    }

    @Override
    public void configureWebApp(WebAppBean webAppBean, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        if (monitor.isCanceled() || webAppBean == null || project == null) {
            return;
        }
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
        Object modelObject = modelProvider.getModelObject();
        if (!(modelObject instanceof WebApp)) {
            return;
        }
        WebApp webApp = (WebApp)modelObject;
        webApp.setDescription(webAppBean.getDescription());
    }

    @Override
    public void initializeWebapp(Map map, IProject project) {
        WebArtifactEdit webEdit;
        if (project == null) {
            return;
        }
        if (map == null) {
            map = new HashMap();
        }
        if ((webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project)) == null) {
            return;
        }
        try {
            WebApp webapp = (WebApp)webEdit.getDeploymentDescriptorRoot();
            this.initializeContextParam(map, webapp);
        }
        finally {
            webEdit.dispose();
        }
    }

    protected void initializeContextParam(Map map, WebApp webapp) {
        if (webapp == null) {
            return;
        }
        Map son = (Map)map.get("context-param");
        if (son == null) {
            return;
        }
        EList list = null;
        list = webapp.getVersionID() == 23 ? webapp.getContexts() : webapp.getContextParams();
        for (String name : son.keySet()) {
            Object obj = this.getContextParamByName((List)list, name);
            if (obj == null) continue;
            String value = null;
            String description = null;
            if (obj instanceof ContextParam) {
                param = (ContextParam)obj;
                name = param.getParamName();
                value = param.getParamValue();
                description = param.getDescription();
            } else if (obj instanceof ParamValue) {
                Description descObj;
                EList descList;
                param = (ParamValue)obj;
                name = param.getName();
                value = param.getValue();
                description = param.getDescription();
                if (description == null && (descList = param.getDescriptions()) != null && descList.size() > 0 && (descObj = (Description)descList.get(0)) != null) {
                    description = descObj.getValue();
                }
            }
            if (value == null) continue;
            ContextParamBean bean = new ContextParamBean(name, value);
            bean.setDescription(description);
            son.put(name, bean);
        }
    }

    private Object getContextParamByName(List list, String name) {
        if (list == null || name == null) {
            return null;
        }
        for (Object paramObj : list) {
            ContextParam param;
            if (paramObj instanceof ContextParam && name.equals((param = (ContextParam)paramObj).getParamName())) {
                return param;
            }
            if (!(paramObj instanceof ParamValue) || !name.equals((param = (ParamValue)paramObj).getName())) continue;
            return param;
        }
        return null;
    }
}

