/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import java.util.HashMap;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.command.SelectionHandler;
import org.eclipse.birt.report.designer.internal.ui.editors.IReportEditor;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ImageEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.LabelEditPart;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.AbstractMultiPageEditor;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;

public class BaseInsertHandler
extends SelectionHandler {
    private String insertType;
    protected SlotHandle slotHandle;
    private Object model;
    protected static final String STACK_MSG_INSERT_ELEMENT = Messages.getString((String)"BaseInsertMenuAction.stackMsg.insertElement");

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Insert action >> Run ...");
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(STACK_MSG_INSERT_ELEMENT);
        boolean retValue = this.initializeVariable(event);
        if (!retValue) {
            return Boolean.FALSE;
        }
        try {
            Request req = this.insertElement();
            if (req != null) {
                stack.commit();
                this.selectElement(req.getExtendedData().get("result"), true);
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        stack.rollback();
        return Boolean.FALSE;
    }

    protected boolean initializeVariable(ExecutionEvent event) {
        IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
        Object obj = UIUtil.getVariableFromContext(context, "EditStyleAction.BaseInserTypeName");
        if (obj == null || obj instanceof String) {
            this.insertType = (String)obj;
        }
        if (this.insertType == null) {
            return false;
        }
        obj = UIUtil.getVariableFromContext(context, "EditStyleAction.BaseInsertSlotHandleName");
        if (obj == null || obj instanceof SlotHandle) {
            this.slotHandle = (SlotHandle)obj;
        }
        if (this.slotHandle == null) {
            return false;
        }
        obj = UIUtil.getVariableFromContext(context, "EditStyleAction.BaseInsertModelName");
        if (obj == null) {
            return false;
        }
        this.model = obj;
        return true;
    }

    protected Request insertElement() throws Exception {
        Request request = new Request((Object)"insert");
        HashMap<String, Object> extendsData = new HashMap<String, Object>();
        extendsData.put("insert-slot", this.slotHandle);
        extendsData.put("insert-type", this.insertType);
        extendsData.put("insert-position", "below");
        request.setExtendedData(extendsData);
        if (ProviderFactory.createProvider(this.slotHandle.getElementHandle()).performRequest(this.model, request)) {
            return request;
        }
        return null;
    }

    protected void selectElement(final Object element, final boolean edit) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (element instanceof ReportItemHandle) {
                    IEditorPart activeEditor;
                    IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
                    IFormPage epart = null;
                    if (part instanceof AbstractMultiPageEditor) {
                        epart = ((AbstractMultiPageEditor)part).getActivePageInstance();
                    } else if (part instanceof IReportEditor && (activeEditor = ((IReportEditor)part).getEditorPart()) instanceof AbstractMultiPageEditor) {
                        epart = ((AbstractMultiPageEditor)activeEditor).getActivePageInstance();
                    }
                    if (epart instanceof GraphicalEditorWithFlyoutPalette) {
                        GraphicalViewer viewer = ((GraphicalEditorWithFlyoutPalette)epart).getGraphicalViewer();
                        Object cpart = viewer.getEditPartRegistry().get(element);
                        if (cpart instanceof EditPart) {
                            viewer.flush();
                            viewer.select((EditPart)cpart);
                        }
                        if (edit && cpart instanceof LabelEditPart) {
                            ((LabelEditPart)cpart).performDirectEdit();
                        } else if (edit && cpart instanceof ImageEditPart) {
                            ((ImageEditPart)cpart).performDirectEdit();
                        }
                    }
                }
            }
        });
    }
}

