/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.derby.diag.DiagUtil;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.vti.VTITemplate;

public class StatementDuration
extends VTITemplate {
    private boolean gotFile;
    private InputStreamReader inputFileStreamReader;
    private InputStream inputStream;
    private BufferedReader bufferedReader;
    private String inputFileName;
    private Hashtable<String, String[]> hashTable;
    private String line;
    private int endTimestampIndex;
    private int threadIndex;
    private int xidIndex;
    private int lccidIndex;
    private String[] currentRow;
    private static final String END_TIMESTAMP = " Thread";
    private static final String BEGIN_THREAD_STRING = "[";
    private static final String END_THREAD_STRING = "]";
    private static final String BEGIN_XID_STRING = "= ";
    private static final String END_XID_STRING = ")";
    private static final String BEGIN_EXECUTING_STRING = "Executing prepared";
    private static final String END_EXECUTING_STRING = " :End prepared";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("TS", 12, false, 29), EmbedResultSetMetaData.getResultColumnDescriptor("THREADID", 12, false, 80), EmbedResultSetMetaData.getResultColumnDescriptor("XID", 12, false, 15), EmbedResultSetMetaData.getResultColumnDescriptor("LCCID", 12, false, 10), EmbedResultSetMetaData.getResultColumnDescriptor("LOGTEXT", 12, true, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("DURATION", 12, false, 10)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public StatementDuration() throws StandardException {
        DiagUtil.checkAccess();
        String home = System.getProperty("derby.system.home");
        this.inputFileName = "derby.log";
        if (home != null) {
            this.inputFileName = home + "/" + this.inputFileName;
        }
    }

    public StatementDuration(String inputFileName) throws StandardException {
        DiagUtil.checkAccess();
        this.inputFileName = inputFileName;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public boolean next() throws SQLException {
        String[] previousRow;
        String[] newRow;
        if (!this.gotFile) {
            this.gotFile = true;
            try {
                this.inputFileStreamReader = new InputStreamReader(new FileInputStream(this.inputFileName));
                this.bufferedReader = new BufferedReader(this.inputFileStreamReader, 32768);
            }
            catch (FileNotFoundException ex) {
                throw new SQLException(ex.getMessage());
            }
            this.hashTable = new Hashtable();
        }
        while (true) {
            try {
                this.line = this.bufferedReader.readLine();
            }
            catch (IOException ioe) {
                throw new SQLException(ioe.getMessage());
            }
            if (this.line == null) {
                return false;
            }
            this.endTimestampIndex = this.line.indexOf(END_TIMESTAMP);
            this.threadIndex = this.line.indexOf(BEGIN_THREAD_STRING);
            this.xidIndex = this.line.indexOf(BEGIN_XID_STRING);
            this.lccidIndex = this.line.indexOf(BEGIN_XID_STRING, this.xidIndex + 1);
            if (this.endTimestampIndex == -1 || this.threadIndex == -1 || this.xidIndex == -1) continue;
            newRow = new String[6];
            for (int index = 1; index <= 5; ++index) {
                newRow[index - 1] = this.setupColumn(index);
            }
            previousRow = this.hashTable.put(newRow[3], newRow);
            if (previousRow != null) break;
        }
        this.currentRow = previousRow;
        Timestamp endTs = this.stringToTimestamp(newRow[0]);
        long end = endTs.getTime() + (long)(endTs.getNanos() / 1000000);
        Timestamp startTs = this.stringToTimestamp(this.currentRow[0]);
        long start = startTs.getTime() + (long)(startTs.getNanos() / 1000000);
        this.currentRow[5] = Long.toString(end - start);
        return true;
    }

    private Timestamp stringToTimestamp(String raw) throws SQLException {
        String trimmed = raw.trim();
        if (!Character.isDigit(trimmed.charAt(trimmed.length() - 1))) {
            trimmed = trimmed.substring(0, trimmed.length() - 4);
            return Timestamp.valueOf(trimmed);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        try {
            return new Timestamp(sdf.parse(trimmed).getTime());
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void close() {
        if (this.bufferedReader != null) {
            try {
                this.bufferedReader.close();
                this.inputFileStreamReader.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.bufferedReader = null;
                this.inputFileStreamReader = null;
            }
        }
    }

    @Override
    public String getString(int columnNumber) throws SQLException {
        return this.currentRow[columnNumber - 1];
    }

    private String setupColumn(int columnNumber) throws SQLException {
        switch (columnNumber) {
            case 1: {
                return this.line.substring(0, this.endTimestampIndex);
            }
            case 2: {
                return this.line.substring(this.threadIndex + 1, this.line.indexOf(END_THREAD_STRING));
            }
            case 3: {
                return this.line.substring(this.xidIndex + 2, this.line.indexOf(END_XID_STRING, this.xidIndex));
            }
            case 4: {
                return this.line.substring(this.lccidIndex + 2, this.line.indexOf(END_XID_STRING, this.lccidIndex));
            }
            case 5: {
                StringBuffer output = new StringBuffer(64);
                if (this.line.indexOf(BEGIN_EXECUTING_STRING) == -1) {
                    output.append(this.line.substring(this.line.indexOf(END_XID_STRING, this.lccidIndex) + 3));
                } else {
                    int endIndex = this.line.indexOf(END_EXECUTING_STRING, this.lccidIndex);
                    if (endIndex == -1) {
                        output.append(this.line.substring(this.line.indexOf(END_XID_STRING, this.lccidIndex) + 3));
                    } else {
                        output.append(this.line.substring(this.line.indexOf(END_XID_STRING, this.lccidIndex) + 3, endIndex));
                    }
                    while (endIndex == -1) {
                        try {
                            this.line = this.bufferedReader.readLine();
                        }
                        catch (IOException ioe) {
                            throw new SQLException("Error reading file " + ioe);
                        }
                        endIndex = this.line.indexOf(END_EXECUTING_STRING);
                        if (endIndex == -1) {
                            output.append(this.line);
                            continue;
                        }
                        output.append(this.line.substring(0, endIndex));
                    }
                }
                return StringUtil.truncate(output.toString(), 32672);
            }
        }
        return null;
    }

    @Override
    public boolean wasNull() {
        return false;
    }
}

