/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.security.Permission;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.AutoloadedDriver;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.jdbc.JDBC;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.services.jmx.ManagementService;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.EmbedCallableStatement;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedDatabaseMetaData;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.mbeans.JDBCMBean;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

public class InternalDriver
implements ModuleControl,
Driver {
    private static final Object syncMe = new Object();
    private static InternalDriver activeDriver;
    private Object mbean;
    protected boolean active;
    private ContextService contextServiceFactory = InternalDriver.getContextService();
    private AuthenticationService authenticationService;
    private static boolean deregister;
    private static final ExecutorService _executorPool;
    private static final String[] BOOLEAN_CHOICES;

    public static final InternalDriver activeDriver() {
        return activeDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        Object object = syncMe;
        synchronized (object) {
            activeDriver = this;
        }
        this.active = true;
        this.mbean = ((ManagementService)InternalDriver.getSystemModule("org.apache.derby.iapi.services.jmx.ManagementService")).registerMBean(new JDBC(this), JDBCMBean.class, "type=JDBC");
        AutoloadedDriver.registerDriverModule(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = syncMe;
        synchronized (object) {
            activeDriver = null;
        }
        ((ManagementService)InternalDriver.getSystemModule("org.apache.derby.iapi.services.jmx.ManagementService")).unregisterMBean(this.mbean);
        this.active = false;
        this.contextServiceFactory = null;
        AutoloadedDriver.unregisterDriverModule();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.active && InternalDriver.embeddedDriverAcceptsURL(url);
    }

    public static boolean embeddedDriverAcceptsURL(String url) throws SQLException {
        if (url == null) {
            throw Util.generateCsSQLException("XJ028.C", "null");
        }
        return !url.startsWith("jdbc:derby:net:") && !url.startsWith("jdbc:derby://") && (url.startsWith("jdbc:derby:") || url.equals("jdbc:default:connection"));
    }

    public Connection connect(String url, Properties info, int loginTimeoutSeconds) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (EmbedConnection.memoryState.isLowMemory()) {
            throw EmbedConnection.NO_MEM;
        }
        boolean current = url.equals("jdbc:default:connection");
        if (current) {
            ConnectionContext connContext = this.getConnectionContext();
            if (connContext != null) {
                return connContext.getNestedConnection(false);
            }
            return null;
        }
        FormatableProperties finfo = null;
        try {
            finfo = this.getAttributes(url, info);
            info = null;
            boolean shutdown = Boolean.valueOf(finfo.getProperty("shutdown"));
            if (shutdown && InternalDriver.getDatabaseName(url, finfo).length() == 0) {
                if (this.getAuthenticationService() == null) {
                    throw Util.generateCsSQLException("08004", MessageService.getTextMessage("A001", new Object[0]));
                }
                if (!this.getAuthenticationService().authenticate(null, finfo)) {
                    throw Util.generateCsSQLException("08004.C.1", MessageService.getTextMessage("A020", new Object[0]));
                }
                if (finfo.getProperty("deregister") != null) {
                    boolean deregister = Boolean.valueOf(finfo.getProperty("deregister"));
                    InternalDriver.setDeregister(deregister);
                }
                InternalDriver.getMonitor().shutdown();
                throw Util.generateCsSQLException("XJ015.M", new Object[0]);
            }
            EmbedConnection conn = loginTimeoutSeconds <= 0 ? this.getNewEmbedConnection(url, finfo) : this.timeLogin(url, finfo, loginTimeoutSeconds);
            if (conn.isClosed()) {
                Connection connection = null;
                return connection;
            }
            EmbedConnection embedConnection = conn;
            return embedConnection;
        }
        catch (OutOfMemoryError noMemory) {
            EmbedConnection.memoryState.setLowMemory();
            throw EmbedConnection.NO_MEM;
        }
        finally {
            if (finfo != null) {
                finfo.clearDefaults();
            }
        }
    }

    private EmbedConnection timeLogin(String url, Properties info, int loginTimeoutSeconds) throws SQLException {
        try {
            LoginCallable callable = new LoginCallable(this, url, info);
            Future<EmbedConnection> task = _executorPool.submit(callable);
            long now = System.currentTimeMillis();
            long giveUp = now + (long)loginTimeoutSeconds * 1000L;
            while (now < giveUp) {
                try {
                    EmbedConnection embedConnection = task.get(giveUp - now, TimeUnit.MILLISECONDS);
                    return embedConnection;
                }
                catch (InterruptedException ie) {
                    InterruptStatus.setInterrupted();
                    now = System.currentTimeMillis();
                }
                catch (ExecutionException ee) {
                    throw this.processException(ee);
                }
                catch (TimeoutException te) {
                    throw Util.generateCsSQLException("XBDA0.C.1", new Object[0]);
                }
            }
            throw Util.generateCsSQLException("XBDA0.C.1", new Object[0]);
        }
        finally {
            InterruptStatus.restoreIntrFlagIfSeen();
        }
    }

    private SQLException processException(Throwable t) {
        Throwable cause = t.getCause();
        if (cause instanceof SQLException) {
            return (SQLException)cause;
        }
        return Util.javaException(t);
    }

    public void checkSystemPrivileges(String user, Permission perm) {
        SecurityUtil.checkUserHasPermission(user, perm);
    }

    private void checkShutdownPrivileges(String user) throws SQLException {
    }

    @Override
    public int getMajorVersion() {
        return InternalDriver.getMonitor().getEngineVersion().getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return InternalDriver.getMonitor().getEngineVersion().getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    protected FormatableProperties getAttributes(String url, Properties info) throws SQLException {
        FormatableProperties finfo = new FormatableProperties(info);
        info = null;
        StringTokenizer st = new StringTokenizer(url, ";");
        st.nextToken();
        while (st.hasMoreTokens()) {
            String v = st.nextToken();
            int eqPos = v.indexOf(61);
            if (eqPos == -1) {
                throw Util.generateCsSQLException("XJ028.C", url);
            }
            finfo.put(v.substring(0, eqPos).trim(), v.substring(eqPos + 1).trim());
        }
        InternalDriver.checkBoolean(finfo, "dataEncryption");
        InternalDriver.checkBoolean(finfo, "create");
        InternalDriver.checkBoolean(finfo, "shutdown");
        InternalDriver.checkBoolean(finfo, "deregister");
        InternalDriver.checkBoolean(finfo, "upgrade");
        return finfo;
    }

    private static void checkBoolean(Properties set, String attribute) throws SQLException {
        String[] booleanChoices = new String[]{"true", "false"};
        InternalDriver.checkEnumeration(set, attribute, booleanChoices);
    }

    private static void checkEnumeration(Properties set, String attribute, String[] choices) throws SQLException {
        String value = set.getProperty(attribute);
        if (value == null) {
            return;
        }
        for (int i = 0; i < choices.length; ++i) {
            if (!value.toUpperCase(Locale.ENGLISH).equals(choices[i].toUpperCase(Locale.ENGLISH))) continue;
            return;
        }
        Object choicesStr = "{";
        for (int i = 0; i < choices.length; ++i) {
            if (i > 0) {
                choicesStr = (String)choicesStr + "|";
            }
            choicesStr = (String)choicesStr + choices[i];
        }
        throw Util.generateCsSQLException("XJ05B.C", attribute, value, (String)choicesStr + "}");
    }

    public static String getDatabaseName(String url, Properties info) {
        if (url.equals("jdbc:default:connection")) {
            return "";
        }
        int attributeStart = url.indexOf(59);
        String dbname = attributeStart == -1 ? url.substring("jdbc:derby:".length()) : url.substring("jdbc:derby:".length(), attributeStart);
        if (dbname.length() == 0 && info != null) {
            dbname = info.getProperty("databaseName", dbname);
        }
        dbname = dbname.trim();
        return dbname;
    }

    public final ContextService getContextServiceFactory() {
        return this.contextServiceFactory;
    }

    public AuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = (AuthenticationService)InternalDriver.findService("org.apache.derby.iapi.jdbc.AuthenticationService", "authentication");
        }
        return this.authenticationService;
    }

    EmbedConnection getNewEmbedConnection(String url, Properties info) throws SQLException {
        InternalDriver myself = this;
        return new EmbedConnection(myself, url, info);
    }

    private ConnectionContext getConnectionContext() {
        ContextManager cm = this.getCurrentContextManager();
        ConnectionContext localCC = null;
        if (cm != null) {
            localCC = (ConnectionContext)((Object)cm.getContext("JDBC_ConnectionContext"));
        }
        return localCC;
    }

    private ContextManager getCurrentContextManager() {
        return this.getContextServiceFactory().getCurrentContextManager();
    }

    public boolean isActive() {
        return this.active;
    }

    public Connection getNewNestedConnection(EmbedConnection conn) {
        return new EmbedConnection(conn);
    }

    public Statement newEmbedStatement(EmbedConnection conn, boolean forMetaData, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new EmbedStatement(conn, forMetaData, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement newEmbedPreparedStatement(EmbedConnection conn, String stmt, boolean forMetaData, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        return new EmbedPreparedStatement(conn, stmt, forMetaData, resultSetType, resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, columnIndexes, columnNames);
    }

    public CallableStatement newEmbedCallableStatement(EmbedConnection conn, String stmt, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new EmbedCallableStatement(conn, stmt, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public DatabaseMetaData newEmbedDatabaseMetaData(EmbedConnection conn, String dbname) throws SQLException {
        return new EmbedDatabaseMetaData(conn, dbname);
    }

    public EmbedResultSet newEmbedResultSet(EmbedConnection conn, ResultSet results, boolean forMetaData, EmbedStatement statement, boolean isAtomic) throws SQLException {
        return new EmbedResultSet(conn, results, forMetaData, statement, isAtomic);
    }

    public EmbedResultSetMetaData newEmbedResultSetMetaData(ResultColumnDescriptor[] columnInfo) {
        return new EmbedResultSetMetaData(columnInfo);
    }

    public BrokeredConnection newBrokeredConnection(BrokeredConnectionControl control) throws SQLException {
        return new BrokeredConnection(control);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info != null && Boolean.valueOf(info.getProperty("shutdown")).booleanValue()) {
            return new DriverPropertyInfo[0];
        }
        String dbname = InternalDriver.getDatabaseName(url, info);
        FormatableProperties finfo = this.getAttributes(url, info);
        info = null;
        boolean encryptDB = Boolean.valueOf(finfo.getProperty("dataEncryption"));
        String encryptpassword = finfo.getProperty("bootPassword");
        if (dbname.length() == 0 || encryptDB && encryptpassword == null) {
            String[][] connStringAttributes = new String[][]{{"databaseName", "J004"}, {"encryptionProvider", "J016"}, {"encryptionAlgorithm", "J017"}, {"encryptionKeyLength", "J018"}, {"encryptionKey", "J019"}, {"territory", "J021"}, {"collation", "J031"}, {"user", "J022"}, {"logDevice", "J025"}, {"rollForwardRecoveryFrom", "J028"}, {"createFrom", "J029"}, {"restoreFrom", "J030"}};
            String[][] connBooleanAttributes = new String[][]{{"shutdown", "J005"}, {"deregister", "J006"}, {"create", "J007"}, {"dataEncryption", "J010"}, {"upgrade", "J013"}};
            String[][] connStringSecretAttributes = new String[][]{{"bootPassword", "J020"}, {"password", "J023"}};
            DriverPropertyInfo[] optionsNoDB = new DriverPropertyInfo[connStringAttributes.length + connBooleanAttributes.length + connStringSecretAttributes.length];
            int attrIndex = 0;
            int i = 0;
            while (i < connStringAttributes.length) {
                optionsNoDB[attrIndex] = new DriverPropertyInfo(connStringAttributes[i][0], finfo.getProperty(connStringAttributes[i][0]));
                optionsNoDB[attrIndex].description = MessageService.getTextMessage(connStringAttributes[i][1], new Object[0]);
                ++i;
                ++attrIndex;
            }
            optionsNoDB[0].choices = InternalDriver.getMonitor().getServiceList("org.apache.derby.database.Database");
            optionsNoDB[0].value = dbname;
            i = 0;
            while (i < connStringSecretAttributes.length) {
                optionsNoDB[attrIndex] = new DriverPropertyInfo(connStringSecretAttributes[i][0], finfo.getProperty(connStringSecretAttributes[i][0]) == null ? "" : "****");
                optionsNoDB[attrIndex].description = MessageService.getTextMessage(connStringSecretAttributes[i][1], new Object[0]);
                ++i;
                ++attrIndex;
            }
            i = 0;
            while (i < connBooleanAttributes.length) {
                optionsNoDB[attrIndex] = new DriverPropertyInfo(connBooleanAttributes[i][0], Boolean.valueOf(finfo == null ? "" : finfo.getProperty(connBooleanAttributes[i][0])).toString());
                optionsNoDB[attrIndex].description = MessageService.getTextMessage(connBooleanAttributes[i][1], new Object[0]);
                optionsNoDB[attrIndex].choices = BOOLEAN_CHOICES;
                ++i;
                ++attrIndex;
            }
            return optionsNoDB;
        }
        return new DriverPropertyInfo[0];
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.connect(url, info, DriverManager.getLoginTimeout());
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)Util.notImplemented("getParentLogger()");
    }

    public static void setDeregister(boolean deregister) {
        InternalDriver.deregister = deregister;
    }

    public static boolean getDeregister() {
        return deregister;
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object getSystemModule(String factoryInterface) {
        return Monitor.getSystemModule(factoryInterface);
    }

    private static Object findService(String factoryInterface, String serviceName) {
        return Monitor.findService(factoryInterface, serviceName);
    }

    static {
        deregister = true;
        _executorPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory());
        BOOLEAN_CHOICES = new String[]{"false", "true"};
    }

    public static final class LoginCallable
    implements Callable<EmbedConnection> {
        private InternalDriver _driver;
        private String _url;
        private Properties _info;

        public LoginCallable(InternalDriver driver, String url, Properties info) {
            this._driver = driver;
            this._url = url;
            this._info = info;
        }

        @Override
        public EmbedConnection call() throws SQLException {
            String url = this._url;
            Properties info = this._info;
            InternalDriver driver = this._driver;
            this._url = null;
            this._info = null;
            this._driver = null;
            return driver.getNewEmbedConnection(url, info);
        }
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread result = new Thread(r);
            result.setDaemon(true);
            return result;
        }
    }
}

