/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.TriggerEvent;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class GenericTriggerExecutor {
    final InternalTriggerExecutionContext tec;
    final TriggerDescriptor triggerd;
    final Activation activation;
    private final LanguageConnectionContext lcc;
    private boolean whenClauseRetrieved;
    private boolean actionRetrieved;
    private SPSDescriptor whenClause;
    private SPSDescriptor action;
    private ExecPreparedStatement whenPS;
    private Activation spsWhenActivation;
    private ExecPreparedStatement actionPS;
    private Activation spsActionActivation;

    GenericTriggerExecutor(InternalTriggerExecutionContext tec, TriggerDescriptor triggerd, Activation activation, LanguageConnectionContext lcc) {
        this.tec = tec;
        this.triggerd = triggerd;
        this.activation = activation;
        this.lcc = lcc;
    }

    abstract void fireTrigger(TriggerEvent var1, CursorResultSet var2, CursorResultSet var3, int[] var4) throws StandardException;

    private SPSDescriptor getWhenClause() throws StandardException {
        if (!this.whenClauseRetrieved) {
            this.whenClauseRetrieved = true;
            this.whenClause = this.triggerd.getWhenClauseSPS(this.lcc);
        }
        return this.whenClause;
    }

    private SPSDescriptor getAction() throws StandardException {
        if (!this.actionRetrieved) {
            this.actionRetrieved = true;
            this.action = this.triggerd.getActionSPS(this.lcc);
        }
        return this.action;
    }

    private boolean executeSPS(SPSDescriptor sps, boolean isWhen) throws StandardException {
        Activation spsActivation;
        boolean recompile = false;
        boolean whenClauseWasTrue = false;
        ExecPreparedStatement ps = isWhen ? this.whenPS : this.actionPS;
        Activation activation = spsActivation = isWhen ? this.spsWhenActivation : this.spsActionActivation;
        while (true) {
            if (ps == null || recompile) {
                this.lcc.getStatementContext().setActivation(this.activation);
                ps = sps.getPreparedStatement();
                ps = ps.getClone();
                ps.setValid();
                spsActivation = ps.getActivation(this.lcc, false);
                ps.setSource(sps.getText());
                ps.setSPSAction();
                if (isWhen) {
                    this.whenPS = ps;
                    this.spsWhenActivation = spsActivation;
                } else {
                    this.actionPS = ps;
                    this.spsActionActivation = spsActivation;
                }
            }
            StatementContext active_sc = this.lcc.getStatementContext();
            try {
                ResultSet rs = ps.executeSubStatement(this.activation, spsActivation, false, 0L);
                if (isWhen) {
                    ExecRow row = rs.getNextRow();
                    if (row.nColumns() != 1) {
                        SanityManager.THROWASSERT("Expected WHEN clause to have exactly one column, found: " + row.nColumns());
                    }
                    DataValueDescriptor value = row.getColumn(1);
                    SanityManager.ASSERT(value instanceof SQLBoolean);
                    whenClauseWasTrue = !value.isNull() && value.getBoolean();
                    SanityManager.ASSERT(rs.getNextRow() == null, "WHEN clause returned more than one row");
                } else if (rs.returnsRows()) {
                    while (rs.getNextRow() != null) {
                    }
                }
                rs.close();
            }
            catch (StandardException e) {
                StatementContext sc = this.lcc.getStatementContext();
                if (sc != null && active_sc != sc) {
                    sc.cleanupOnError(e);
                }
                if (e.getMessageId().equals("XCL32.S")) {
                    recompile = true;
                    sps.revalidate(this.lcc);
                    continue;
                }
                spsActivation.close();
                throw e;
            }
            break;
        }
        return whenClauseWasTrue;
    }

    protected void clearSPS() throws StandardException {
        if (this.spsActionActivation != null) {
            this.spsActionActivation.close();
        }
        this.actionPS = null;
        this.spsActionActivation = null;
        if (this.spsWhenActivation != null) {
            this.spsWhenActivation.close();
        }
        this.whenPS = null;
        this.spsWhenActivation = null;
    }

    final void executeWhenClauseAndAction() throws StandardException {
        SPSDescriptor whenClauseDescriptor = this.getWhenClause();
        if (whenClauseDescriptor == null || this.executeSPS(whenClauseDescriptor, true)) {
            this.executeSPS(this.getAction(), false);
        }
    }
}

