/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SearchParameters {
    public static final int POSITION_LEFT_OF_PARTIAL_KEY_MATCH = 1;
    public static final int POSITION_RIGHT_OF_PARTIAL_KEY_MATCH = -1;
    public DataValueDescriptor[] searchKey;
    int partial_key_match_op;
    public DataValueDescriptor[] template;
    public OpenBTree btree;
    public int resultSlot;
    public boolean resultExact;
    public boolean searchForOptimizer;
    public float left_fraction;
    public float current_fraction;

    public SearchParameters(DataValueDescriptor[] searchKey, int partial_key_match_op, DataValueDescriptor[] template, OpenBTree btree, boolean searchForOptimizer) throws StandardException {
        this.searchKey = searchKey;
        this.partial_key_match_op = partial_key_match_op;
        this.template = template;
        this.btree = btree;
        this.resultSlot = 0;
        this.resultExact = false;
        this.searchForOptimizer = searchForOptimizer;
        if (this.searchForOptimizer) {
            this.left_fraction = 0.0f;
            this.current_fraction = 1.0f;
        }
        SanityManager.ASSERT(partial_key_match_op == -1 || partial_key_match_op == 1);
    }

    public String toString() {
        String string = "key = " + RowUtil.toString(this.searchKey) + ";op = " + (String)(this.partial_key_match_op == 1 ? "GE" : (this.partial_key_match_op == -1 ? "GT" : "BAD OP:" + this.partial_key_match_op)) + ";template = " + RowUtil.toString(this.template) + ";Slot = " + this.resultSlot + ";Exact = " + this.resultExact + ";";
        return string;
    }
}

