/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.internal.util.EclipseUtil;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFont;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFontConfig;
import org.eclipse.birt.report.engine.layout.pdf.font.FontConfigReader;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingConfig;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.util.SecurityUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.openpdf.text.FontFactory;
import org.openpdf.text.pdf.BaseFont;
import org.osgi.framework.Bundle;

public class FontMappingManagerFactory {
    protected static Logger logger = Logger.getLogger(FontConfigReader.class.getName());
    protected static FontMappingManagerFactory instance;
    private static URL customFontConfig;
    protected HashSet<String> fontPathes = new HashSet();
    protected HashMap<String, String> fontEncodings = new HashMap();
    protected HashMap<String, FontMappingConfig> cachedConfigs = new HashMap();
    protected HashMap<Object, HashMap<Locale, FontMappingManager>> cachedManagers = new HashMap();
    static final String CONFIG_NAME = "fontsConfig";
    HashMap<CompositeFontConfig, HashMap<String[], CompositeFont>> cachedCompositeFonts = new HashMap();
    private HashMap<String, BaseFont> baseFonts = new HashMap();

    static {
        customFontConfig = null;
    }

    public static synchronized FontMappingManagerFactory getInstance() {
        if (instance == null) {
            instance = new FontMappingManagerFactory();
        }
        return instance;
    }

    protected FontMappingManagerFactory() {
        this.registerJavaFonts();
        String embeddedFonts = this.getEmbededFontPath();
        if (embeddedFonts != null) {
            FontMappingManagerFactory.registerFontPath(embeddedFonts);
        }
    }

    public synchronized FontMappingManager getFontMappingManager(String format, Locale locale) {
        FontMappingManager manager;
        HashMap<Locale, FontMappingManager> managers = this.cachedManagers.get(format);
        if (managers == null) {
            managers = new HashMap();
            this.cachedManagers.put(format, managers);
        }
        if ((manager = managers.get(locale)) == null) {
            manager = this.createFontMappingManager(format, locale);
            managers.put(locale, manager);
        }
        return manager;
    }

    public FontMappingManager createFontMappingManager(FontMappingConfig config, Locale locale) {
        this.registerJavaFonts();
        for (String fontPath : config.fontPaths) {
            if (this.fontPathes.contains(fontPath)) continue;
            this.fontPathes.add(fontPath);
            FontMappingManagerFactory.registerFontPath(fontPath);
        }
        this.fontEncodings.putAll(config.fontEncodings);
        return new FontMappingManager(this, null, config, locale);
    }

    public static void setCustomFontConfig(URL customFontConfig) {
        FontMappingManagerFactory.customFontConfig = customFontConfig;
    }

    private void registerJavaFonts() {
        String javaHome = System.getProperty("java.home");
        String fontsFolder = javaHome + File.separatorChar + "lib" + File.separatorChar + "fonts";
        FontFactory.registerDirectory((String)fontsFolder);
    }

    protected FontMappingManager createFontMappingManager(String format, Locale locale) {
        String formatString = format.toLowerCase();
        String[] configNames = new String[19];
        int count = 0;
        String osgiName = this.getOSGIOSName();
        String osName = this.getOSName();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder sb = new StringBuilder();
        configNames[count++] = sb.append(CONFIG_NAME).toString();
        if (osgiName != null) {
            configNames[count++] = sb.append('_').append(osgiName).toString();
            configNames[count++] = sb.append('_').append(language).toString();
            configNames[count++] = sb.append('_').append(country).toString();
            configNames[count++] = sb.append('_').append(variant).toString();
        }
        if (osName != null && !osName.equals(osgiName)) {
            sb.setLength(0);
            sb.append(CONFIG_NAME);
            configNames[count++] = sb.append('_').append(osName).toString();
            configNames[count++] = sb.append('_').append(language).toString();
            configNames[count++] = sb.append('_').append(country).toString();
            configNames[count++] = sb.append('_').append(variant).toString();
        }
        sb.setLength(0);
        configNames[count++] = sb.append(CONFIG_NAME).append('_').append(formatString).toString();
        if (osgiName != null) {
            configNames[count++] = sb.append('_').append(osgiName).toString();
            configNames[count++] = sb.append('_').append(language).toString();
            configNames[count++] = sb.append('_').append(country).toString();
            configNames[count++] = sb.append('_').append(variant).toString();
        }
        if (osName != null && !osName.equals(osgiName)) {
            sb.setLength(0);
            sb.append(CONFIG_NAME).append('_').append(formatString);
            configNames[count++] = sb.append('_').append(osName).toString();
            configNames[count++] = sb.append('_').append(language).toString();
            configNames[count++] = sb.append('_').append(country).toString();
            configNames[count++] = sb.append('_').append(variant).toString();
        }
        FontMappingManager manager = null;
        int i = 0;
        while (i < count) {
            FontMappingConfig config = this.loadFontMappingConfig(configNames[i]);
            if (config != null) {
                manager = this.createFontMappingManager(manager, config, locale);
            }
            ++i;
        }
        FontMappingConfig customConfig = this.loadCustomFontConfig();
        if (customConfig != null) {
            manager = this.createFontMappingManager(manager, customConfig, locale);
        }
        return manager;
    }

    protected FontMappingManager createFontMappingManager(FontMappingManager parent, FontMappingConfig config, Locale locale) {
        FontMappingManager manager;
        HashMap<Locale, FontMappingManager> managers = this.cachedManagers.get(config);
        if (managers == null) {
            managers = new HashMap();
            this.cachedManagers.put(config, managers);
        }
        if ((manager = managers.get(locale)) == null) {
            manager = new FontMappingManager(this, parent, config, locale);
            managers.put(locale, manager);
        }
        return manager;
    }

    private String getOSName() {
        String osName = SecurityUtil.getSystemProperty("os.name");
        if (osName != null) {
            return osName.replace(' ', '_');
        }
        return null;
    }

    private String getOSGIOSName() {
        String osName = Platform.getOS();
        if ("unknown".equals(osName)) {
            return null;
        }
        return osName;
    }

    protected FontMappingConfig getFontMappingConfig(String configName) {
        FontMappingConfig config = this.cachedConfigs.get(configName);
        if (config == null && !this.cachedConfigs.containsKey(configName)) {
            config = this.loadFontMappingConfig(configName);
            this.cachedConfigs.put(configName, config);
        }
        return config;
    }

    protected FontMappingConfig loadFontMappingConfig(String configName) {
        URL url = this.getConfigURL(configName);
        if (url != null) {
            try {
                return this.loadFontMappingConfig(url);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, configName + ":" + ex.getMessage(), ex);
            }
        }
        return null;
    }

    protected FontMappingConfig loadCustomFontConfig() {
        try {
            return this.loadFontMappingConfig(customFontConfig);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, String.valueOf(customFontConfig) + ":" + ex.getMessage(), ex);
            return null;
        }
    }

    protected FontMappingConfig loadFontMappingConfig(URL url) throws Exception {
        if (url != null) {
            long start = System.currentTimeMillis();
            FontMappingConfig config = new FontConfigReader().parseConfig(url);
            long end = System.currentTimeMillis();
            logger.info("load font config in " + String.valueOf(url) + " cost " + (end - start) + "ms");
            if (config != null) {
                for (String fontPath : config.fontPaths) {
                    if (this.fontPathes.contains(fontPath)) continue;
                    this.fontPathes.add(fontPath);
                    FontMappingManagerFactory.registerFontPath(fontPath);
                }
                this.fontEncodings.putAll(config.fontEncodings);
                return config;
            }
        }
        return null;
    }

    protected URL getConfigURL(String configName) {
        String fileName = configName + ".xml";
        Bundle bundle = EclipseUtil.getBundle((String)"org.eclipse.birt.report.engine.fonts");
        if (bundle != null) {
            return bundle.getEntry(fileName);
        }
        return this.getClass().getClassLoader().getResource(fileName);
    }

    CompositeFont createCompositeFont(FontMappingManager manager, CompositeFontConfig fontConfig, String[] sequence) {
        CompositeFont font;
        HashMap<Object, CompositeFont> fonts = this.cachedCompositeFonts.get(fontConfig);
        if (fonts == null) {
            fonts = new HashMap();
            this.cachedCompositeFonts.put(fontConfig, fonts);
        }
        if ((font = fonts.get(sequence)) == null) {
            font = new CompositeFont(manager, fontConfig, sequence);
            fonts.put(sequence, font);
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFont createFont(String familyName, int fontStyle) {
        String key = familyName + fontStyle;
        BaseFont bf = null;
        HashMap<String, BaseFont> hashMap = this.baseFonts;
        synchronized (hashMap) {
            if (this.baseFonts.containsKey(key)) {
                bf = this.baseFonts.get(key);
            } else {
                try {
                    String fontEncoding = this.fontEncodings.get(familyName);
                    if (fontEncoding == null) {
                        fontEncoding = "Identity-H";
                    }
                    bf = FontFactory.getFont((String)familyName, (String)fontEncoding, (boolean)true, (float)14.0f, (int)fontStyle).getBaseFont();
                }
                catch (Throwable de) {
                    logger.log(Level.WARNING, de.getMessage(), de);
                }
                this.baseFonts.put(key, bf);
            }
            if (bf == null && fontStyle != 0) {
                return this.createFont(familyName, 0);
            }
        }
        return bf;
    }

    private static void registerFontPath(String fontPath) {
        long start = System.currentTimeMillis();
        File file = new File(fontPath);
        if (file.exists()) {
            if (file.isDirectory()) {
                FontFactory.registerDirectory((String)fontPath);
            } else {
                FontFactory.register((String)fontPath);
            }
        }
        long end = System.currentTimeMillis();
        logger.info("register fonts in " + fontPath + " cost:" + (end - start) + "ms");
    }

    protected String getEmbededFontPath() {
        Bundle bundle = EclipseUtil.getBundle((String)"org.eclipse.birt.report.engine.fonts");
        if (bundle == null) {
            return null;
        }
        Path path = new Path("/fonts");
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (fileURL == null) {
            return null;
        }
        String fontPath = null;
        try {
            fontPath = FileLocator.toFileURL((URL)fileURL).getPath();
            if (fontPath != null && fontPath.length() >= 3 && fontPath.charAt(2) == ':') {
                return fontPath.substring(1);
            }
            return fontPath;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
            return null;
        }
    }

    public HashSet<String> getFontPathes() {
        return this.fontPathes;
    }
}

