/*******************************************************************************
 * Copyright (c) 2008 Actuate Corporation.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0/.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.chart.ui.swt.interfaces;

import org.eclipse.swt.widgets.Canvas;

/**
 * Provides preview functionality if current task supports preview
 */

public interface ITaskPreviewable {

	/**
	 * Indicates if current task can preview chart or not.
	 *
	 * @return support preview or not
	 */
	boolean isPreviewable();

	/**
	 * Returns the canvas which displays preview result
	 *
	 * @return canvas
	 */
	Canvas getPreviewCanvas();

	/**
	 * Creates preview painter
	 *
	 * @return preview painter
	 */
	IChartPreviewPainter createPreviewPainter();

	/**
	 * Renders the preview in canvas
	 */
	void doPreview();
}
